package com.atlassian.plugins.navlink.consumer.projectshortcuts.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.fugue.Either;
import com.google.common.base.Function;
import com.google.common.base.Functions;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.net.URI;

@XmlRootElement
public class UnauthenticatedRemoteApplication
{
    public UnauthenticatedRemoteApplication(ApplicationId id, String appName, Either<URI, String> appUri, URI authUri)
    {
        this.id = id.get();
        this.appName = appName;
        this.appUri = appUri.fold(new Function<URI, String>()
        {
            @Override
            public String apply(URI from)
            {
                return from.toString();
            }
        }, Functions.<String>identity());
        this.authUri = authUri.toString();
    }

    @XmlElement
    public final String id;

    @XmlElement
    public final String appName;

    @XmlElement
    public final String appUri;

    @XmlElement
    public final String authUri;
}
