package com.atlassian.plugins.navlink.consumer.projectshortcuts.rest;

import com.atlassian.plugins.navlink.producer.contentlinks.rest.ContentLinkEntity;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import java.util.List;

@XmlRootElement(name = "project-shortcuts-envelope")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ProjectShortCutEnvelope
{
    private final List<ContentLinkEntity> shortcuts;

    private final List<UnauthenticatedRemoteApplication> unauthenticatedRemoteApplications;

    public ProjectShortCutEnvelope(List<ContentLinkEntity> links, List<UnauthenticatedRemoteApplication> unauthenticatedRemoteApplications)
    {
        this.shortcuts = links;
        this.unauthenticatedRemoteApplications = unauthenticatedRemoteApplications;
    }
    
    public List<ContentLinkEntity> getShortcuts()
    {
        return shortcuts;
    }

    public List<UnauthenticatedRemoteApplication> getUnauthenticatedRemoteApplications()
    {
        return unauthenticatedRemoteApplications;
    }
}
