package com.atlassian.plugins.navlink.consumer.menu.client.capabilities;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.failurecache.ExpiringValue;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.google.common.util.concurrent.ListenableFuture;

/**
 * Retrieves application capability information from a remote application.
 */
public interface CapabilitiesClient
{
    /**
     * Return a future which will - when executed - fetch the capabilities of the remote application associated via the
     * given application link.
     *
     * @param applicationLink the linked application for which the capabilities are requested
     * @return a future which returns the remote application's capabilities
     */
    ListenableFuture<ExpiringValue<RemoteApplicationWithCapabilities>> getCapabilities(ApplicationLink applicationLink);
}
