package com.atlassian.plugins.navlink.consumer.http;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.util.concurrent.LazyReference;

import static com.google.common.base.Preconditions.checkNotNull;

public class UserAgentPropertyImpl implements UserAgentProperty
{
    private final ApplicationProperties applicationProperties;
    private final LazyReference<String> userAgent = new LazyReference<String>()
    {
        @Override
        protected String create() throws Exception
        {
            return createUserAgent();
        }
    };

    public UserAgentPropertyImpl(final ApplicationProperties applicationProperties)
    {
        this.applicationProperties = checkNotNull(applicationProperties);
    }

    @Override
    public String get()
    {
        return userAgent.get();
    }

    private String createUserAgent()
    {
        return String.format("%s-%s (%s)", applicationProperties.getDisplayName(), applicationProperties.getVersion(), applicationProperties.getBuildNumber());
    }
}
