package com.atlassian.plugins.navlink.consumer.http;

import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;

import javax.annotation.Nonnull;
import java.io.IOException;

import static com.google.common.base.Preconditions.checkNotNull;

public class HttpRequest
{
    private final HttpClient client;
    private final HttpGet request;

    public HttpRequest(@Nonnull final HttpClient client, @Nonnull final HttpGet request)
    {
        this.client = checkNotNull(client);
        this.request = checkNotNull(request);
    }

    @Nonnull
    public <T> T executeRequest(@Nonnull final ResponseHandler<T> responseHandler) throws IOException
    {
        return client.execute(request, withCleanUpHandler(checkNotNull(responseHandler)));
    }

    private <T> ResponseHandler<T> withCleanUpHandler(@Nonnull final ResponseHandler<T> responseHandler)
    {
        return new CleaningUpResponseHandler<T>(responseHandler);
    }
}
