package com.atlassian.plugins.navlink.consumer.http;

import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.IOException;

import static com.google.common.base.Preconditions.checkNotNull;

public class CleaningUpResponseHandler<T> implements ResponseHandler<T>
{
    private final ResponseHandler<T> delegatee;

    public CleaningUpResponseHandler(@Nonnull final ResponseHandler<T> delegatee)
    {
        this.delegatee = checkNotNull(delegatee);
    }

    @Override
    public T handleResponse(final HttpResponse response) throws ClientProtocolException, IOException
    {
        try
        {
            return delegatee.handleResponse(response);
        }
        finally
        {
            cleanUp(response);
        }
    }

    private void cleanUp(@Nullable final HttpResponse response) throws IOException
    {
        if (response != null)
        {
            EntityUtils.consume(response.getEntity());
        }
    }
}
