package com.atlassian.plugins.navlink.common;

import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.google.common.base.Predicate;

import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;

/**
 * Retrieves the navigation links for the local or remote applications.
 * 
 * @see com.atlassian.plugins.navlink.producer.navigation.services.LocalNavigationLinkService
 * @see com.atlassian.plugins.navlink.consumer.menu.services.RemoteNavigationLinkService
 */
public interface NavigationLinkService
{
    @Nonnull
    Set<NavigationLink> all(@Nonnull Locale locale);

    @Nonnull
    Set<NavigationLink> matching(@Nonnull Locale locale, @Nonnull Predicate<NavigationLink> criteria);
}
