package com.atlassian.plugins.navlink.analyticsdata.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON;

@Path("/")
@AnonymousAllowed
public class AnalyticsDataResource
{
    private final UserManager userManager;

    public AnalyticsDataResource(UserManager userManager)
    {
        this.userManager = userManager;
    }

    @GET
    @Consumes(APPLICATION_JSON)
    @Produces(APPLICATION_JSON)
    public Response getAnalyticsData()
    {
        final String username = userManager.getRemoteUsername();

        boolean isUserAdmin = username != null && userManager.isAdmin(username);

        return Response.ok(new AnalyticsData(isUserAdmin)).build();
    }

    @XmlRootElement
    public static class AnalyticsData
    {
        @XmlElement
        public final Boolean isUserAdmin;

        public AnalyticsData(Boolean userAdmin)
        {
            isUserAdmin = userAdmin;
        }
    }
}