(function ($, NL) {
    NL.AppSwitcher = function (options) {
        var ADMIN_EDIT_PATH = AJS.contextPath() + "/plugins/servlet/customize-application-navigator";
        var that = this;
        this.$dropdown = null;

        options = $.extend({
            dropdownContents: null
        }, options);

        this.getLinks = function () {
            return $.ajax({
                url: AJS.contextPath() + '/rest/menu/latest/appswitcher',
                cache: false,
                dataType: 'json'
            }).done(this.updateDropdown).fail(this.showError);
        };

        this.getDropdown = function () {
            if (!this.$dropdown) {
                this.$dropdown = $(options.dropdownContents);
            }
            return this.$dropdown;
        };

        this.updateDropdown = function (data) {
            $(function () {
                that.getDropdown().html(navlinks.templates.appswitcher_old.applications({
                    apps: data,
                    showAdminLink: NL.isUserAdmin,
                    adminLink: ADMIN_EDIT_PATH
                }));

                that.bindAnalyticsHandlers(that.getDropdown(), data);
            });
        };

        this.showError = function () {
            $(function () {
                that.getDropdown()
                        .html(navlinks.templates.appswitcher_old.error())
                        .off('.appswitcher')
                        .on('click.appswitcher', '.app-switcher-retry', $.proxy(that.retryLoading, that));
            });
        };

        this.retryLoading = function (e) {
            this.getDropdown().html(navlinks.templates.appswitcher_old.loading());
            this.getLinks();
            e && e.stopPropagation();
        };

        /**
         * wrapper for NL.trackEvent. We want analytics off the critical path: if there's a bug in our tracking code, we
         * don't want to break functionality.
         */
        this.trackEvent = function (action, label, value) {
            try {
                NL.trackEvent('appswitcher-new', action, label, value);
            } catch (e) {
                AJS.log('failed to track analytics event, category: appswitcher, action: ' + action + ', label: ' + label + ', value: ' + value);
            }
        };

        this.bindAnalyticsHandlers = function ($dropdown, apps) {
            function countCustomLinks() {
                var count = 0;
                for (var key in apps) {
                    var link = apps[key];
                    if (link["custom"]) {
                        count += 1;
                    }
                }
                return count;
            }

            var customLinks = countCustomLinks();

            // our hide events come in regardless of whether the user clicked something inside the dropdown or clicked
            // elsewhere to dismiss it.
            $dropdown.on({
                'aui-dropdown2-show': function (e) {
                    that.trackEvent('show', NL.getCurrentApplication(), apps.length);
                    //that.trackEvent('customLinks', NL.getCurrentApplication(), customLinks);
                },
                'aui-dropdown2-hide': function (e) {
                    that.trackEvent('hide', NL.getCurrentApplication(), apps.length);
                }
            });

            $dropdown.off('.analytics').on('click.analytics', 'a', function (e) {
                that.trackEvent('appSelected', $(this).attr('href'), apps.length);
            });
        };

        this.getLinks();
    };

    if (NL.onInit) {
        NL.onInit();
    }
}(jQuery, window.NL = (window.NL || {})));