var _gaq = _gaq || [];

AJS.$(function(){
    _gaq.push(['navlinks._setAccount', 'UA-20272869-14']);
    _gaq.push(['navlinks._setDomainName', 'none']);
    _gaq.push(['navlinks._setAllowLinker', true]);
    _gaq.push(['navlinks._setDetectTitle', false]);
    _gaq.push(['navlinks._trackPageview', location.pathname]);

    AJS.$.ajax(AJS.contextPath() + '/rest/nav-links-analytics-data/1.0/', {
        success: function(data) {
            _gaq.push(['navlinks._setCustomVar', 1, 'isUserAdmin', data.isUserAdmin ? 'true' : 'false', 2]);
        }
    });

    // don't load ga.js, as we don't have an opt-in mechanism. Rely on OnDemand/GH loading it for us.
    // NOTE: If it's not there, then the size of _gaq is unbounded.
});

(function (NL) {
    function log(category, action, label, synchronous, value) {
        AJS.log('Firing analytics event' + (synchronous ? ' - synchronous' : ''));
        AJS.log('  Category: ' + category);
        AJS.log('  Action:   ' + action);
        AJS.log('  Label:    ' + label);
        if (value !== undefined) {
            AJS.log('  Value:    ' + value);
        }
    }

    NL.trackEvent = function(category, action, label, value) {
        // GA tracking
        if (value === undefined) {
            log(category, action, label, false);
            _gaq.push(['navlinks._trackEvent', category, action, label]);
        } else {
            log(category, action, label, false, value);
            _gaq.push(['navlinks._trackEvent', category, action, label, value]);
        }

        // AJS tracking
        if (AJS.EventQueue) {
            AJS.EventQueue.push({
                name: category + '.' + action,
                properties: {
                    label: label,
                    value: value
                }
            });
        }
    };

    NL.getCurrentApplication = function() {
        // Needs to check for JIRA last as window.JIRA is defined in Confluence (wtf!)
        if (window.Confluence !== undefined) {
            return 'confluence';
        } else if (window.BAMBOO !== undefined) {
            return 'bamboo';
        } else if (window.JIRA !== undefined) {
            return 'jira';
        } else {
            return '';
        }
    }
}(window.NL = (window.NL || {})));