/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.features.rest;

import com.atlassian.plugins.features.rest.DefaultResponse;
import com.atlassian.plugins.features.rest.FeatureKeyValidation;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@LicensedOnly
@Path(value="/user")
@Produces(value={"application/json"})
@Singleton
public class UserDarkFeatureResource {
    private final DarkFeatureManager darkFeaturesManager;

    @Inject
    public UserDarkFeatureResource(DarkFeatureManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    @PUT
    public Response enableFeaturesForCurrentUser(@QueryParam(value="featureKey") List<String> featureKeys) {
        if (featureKeys.stream().anyMatch(FeatureKeyValidation.INVALID_FEATURE_KEY)) {
            return DefaultResponse.respondWith(Response.Status.BAD_REQUEST);
        }
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.enableFeatureForCurrentUser(featureKey);
        }
        return DefaultResponse.respondWith(Response.Status.CREATED);
    }

    @DELETE
    public Response disableFeaturesForCurrentUser(@QueryParam(value="featureKey") List<String> featureKeys) {
        if (featureKeys.stream().anyMatch(FeatureKeyValidation.INVALID_FEATURE_KEY)) {
            return DefaultResponse.respondWith(Response.Status.BAD_REQUEST);
        }
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.disableFeatureForCurrentUser(featureKey);
        }
        return DefaultResponse.respondWith(Response.Status.NO_CONTENT);
    }

    @GET
    public Response getFeatureEnabledForCurrentUser(@QueryParam(value="featureKey") String featureKey) {
        if (featureKey == null) {
            return this.getFeaturesEnabledForCurrentUser();
        }
        return this.isFeatureEnabledForCurrentUser(featureKey);
    }

    private Response isFeatureEnabledForCurrentUser(String featureKey) {
        Response.Status status = this.darkFeaturesManager.isEnabledForCurrentUser(featureKey).orElse(false) != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        return DefaultResponse.respondWith(status);
    }

    private Response getFeaturesEnabledForCurrentUser() {
        Set featureKeys = this.darkFeaturesManager.getFeaturesEnabledForCurrentUser().getFeatureKeySet();
        return DefaultResponse.respondWith(Response.Status.OK, featureKeys);
    }
}

