package com.atlassian.depview.rest;


import com.atlassian.depview.osgi.BundleExplorer;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import java.util.Collection;
import java.util.stream.Collectors;

import static com.atlassian.depview.osgi.WireDirection.PROVIDED;
import static com.atlassian.depview.osgi.WireDirection.REQUIRED;


@XmlAccessorType(XmlAccessType.FIELD)
public class ServiceSummaryBean {
    @XmlElement
    final Collection<Long> usingServicesFrom;

    @XmlElement
    final Collection<Long> providingServicesTo;

    public ServiceSummaryBean(final BundleExplorer explorer) {
        usingServicesFrom = explorer.getServices(REQUIRED).stream()
                .map(s -> s.getBundleId())
                .collect(Collectors.toSet());
        providingServicesTo = explorer.getServices(PROVIDED).stream()
                .flatMap(s -> s.getUsingBundles().stream())
                .collect(Collectors.toSet());
    }
}
