/**
 * Get/set the value at a compound namespace, gracefully adding values where missing.
 * @param {string} namespace
 * @param {!Object} context
 * @param value
 */
if (typeof AJS.namespace === 'undefined') {
    AJS.namespace = function (namespace, context, value) {
        var names = namespace.split(".");
        context = context || window;
        for (var i = 0, n = names.length - 1; i < n; i++) {
            var x = context[names[i]];
            context = (x != null) ? x : context[names[i]] = {};
        }
        return context[names[i]] = value || {};
    };
}

/**
 * AJS.Meta will be the namespace for accessing dynamic metadata passed from the
 * server to JavaScript via the page HTML.
 *
 * @since 5.0
 */
// A backing map to use if the user sets data.
AJS.overrides = {};

AJS.Meta = jQuery.extend({}, AJS.Meta, {

    /**
     * Sets metadata with a key and value, for use when the state of the page changes after
     * loading from the server
     * @param key
     * @param value
     */
    set:function (key, value) {
        AJS.overrides[key] = value;
    },

    /**
     * Returns a value given a key. If no entry exists with the key, undefined is returned.
     * If the string value is "true" or "false" the respective boolean value is returned.
     *
     * @method get
     * @param key
     * @return {String} or {boolean}
     */
    get:function (key) {
        if (typeof AJS.overrides[key] != "undefined") {
            return AJS.overrides[key];
        }

        var metaEl = jQuery("meta[name='ajs-" + key + "']");
        if (!metaEl.length) {
            return undefined;
        }

        var value = metaEl.attr("content");
        return AJS.asBooleanOrString(value);
    },

    /**
     * Returns true if the value for the provided key is equal to "true", else returns false.
     *
     * @method getBoolean
     * @param key
     * @return {boolean}
     */
    getBoolean:function (key) {
        return this.get(key) === true;
    },

    /**
     * Returns a number if the value for the provided key can be converted to one.
     * Good for retrieving content ids to check truthiness (e.g. '0' is truthy but 0 is falsy).
     *
     * @method getNumber
     * @param key
     * @return {number}
     */
    getNumber:function (key) {
        return +this.get(key);
    },

    /**
     * Mainly for use when debugging, returns all Data pairs in a map for eyeballing.
     */
    getAllAsMap:function () {
        var map = {};
        jQuery("meta[name^=ajs-]").each(function () {
            map[this.name.substring(4)] = this.content;
        });
        return jQuery.extend(map, AJS.overrides);
    }
});


if (typeof Class === 'undefined') {
    (function () {
        begetObject = function (obj) {
            var f = function () {
            };
            f.prototype = obj;
            return new f();
        };


        var initializing = false, fnTest = /xyz/.test(function () {
            xyz;
        }) ? /\b_super\b/ : /.*/;

        // The base Class implementation (does nothing)
        this.Class = function () {
        };

        // Create a new Class that inherits from this class
        Class.extend = function () {

            var prop;

            var _super = this.prototype;

            if (arguments.length > 1) {

                var interfaces = AJS.$.makeArray(arguments);

                prop = interfaces.pop();

                var completeInterface;

                AJS.$.each(interfaces, function (i, inter) {
                    if (completeInterface) {
                        completeInterface = completeInterface.extend(inter);
                    }
                    else {
                        completeInterface = inter;
                    }
                });

                return completeInterface.extend(this.prototype).extend(prop);

            }
            else {
                prop = arguments[0];
            }

            // Instantiate a base class (but only create the instance,
            // don't run the init constructor)
            initializing = true;
            var prototype = new this();
            initializing = false;

            // Copy the properties over onto the new prototype
            for (var name in prop) {
                // Check if we're overwriting an existing function

                if (prototype[name] = typeof prop[name] == "function" &&
                        typeof _super[name] == "function" && fnTest.test(prop[name])) {
                    prototype[name] = (function (name, fn) {
                        return function () {
                            var tmp = this._super;

                            // Add a new ._super() method that is the same method
                            // but on the super-class
                            this._super = _super[name];

                            // The method only need to be bound temporarily, so we
                            // remove it when we're done executing
                            var ret = fn.apply(this, arguments);
                            this._super = tmp;

                            return ret;
                        };
                    })(name, prop[name]);
                }
                else if (typeof _super[name] === "object") {
                    var newObj = begetObject(prop[name]);

                    AJS.$.each(_super[name], function (name, obj) {
                        if (!newObj[name]) {
                            newObj[name] = obj;
                        }
                        else if (typeof newObj[name] === "object") {
                            var newSubObj = begetObject(newObj[name]);
                            AJS.$.each(obj, function (subName, subObj) {
                                if (!newSubObj[subName]) {
                                    newSubObj[subName] = subObj;
                                }
                            });
                            newObj[name] = newSubObj;
                        }
                    });

                    prototype[name] = newObj;
                }
                else {
                    prototype[name] = prop[name];
                }
            }

            // The dummy class constructor
            function Class() {
                // All construction is actually done in the init method
                if (!initializing && this.init) {
                    this.init.apply(this, arguments);
                }
            }

            // Populate our constructed prototype object
            Class.fn = Class.prototype = prototype;

            // Enforce the constructor to be what we expect
            Class.constructor = Class;

            // And make this class extendable
            Class.extend = arguments.callee;

            return Class;
        };
    })();
}
