AJS.test.require([
    "com.atlassian.plugin.jslibs:react-16.8.6",
    "com.atlassian.plugin.jslibs:react-dom-16.8.6-factory"
], function () {
    "use strict";

    require([
        "atlassian/libs/react-16.8.6",
        "atlassian/libs/factories/react-dom-16.8.6"
    ], function (
        React,
        ReactDOMFactory
    ) {
        module("atlassian/libs/factories/react-dom-16.8.6");

        test("It returns a function", function () {
            equal(typeof ReactDOMFactory, "function");
        });

        test("It returns a copy of ReactDOM 16.8.6", function () {
            var ReactDOM = ReactDOMFactory(React);
            equal(typeof ReactDOM, "object");
        });

        test("Each call returns a new copy", function () {
            var ReactDOM1 = ReactDOMFactory(React);
            var ReactDOM2 = ReactDOMFactory(React);

            notEqual(ReactDOM1, ReactDOM2);
        });

        test("It uses the provided React", function () {
            this.spy(React, "Component");
            ReactDOMFactory(React);

            // ReactDOM uses React.Component() internally
            sinon.assert.called(React.Component);
        });

    });
});
