AJS.test.require([
    "com.atlassian.plugin.jslibs:backbone.paginator-2.0.2-factory",
    "com.atlassian.plugin.jslibs:backbone-1.0.0-factory",
    "com.atlassian.plugin.jslibs:underscore-1.5.2"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/backbone.paginator-2.0.2",
        "atlassian/libs/factories/backbone-1.0.0",
        "atlassian/libs/underscore-1.5.2",
        "jquery"
    ], function (
        BackbonePaginatorFactory,
        BackboneFactory,
        _,
        $
    ) {
        var Backbone = BackboneFactory(_, $);

        module("atlassian/libs/factories/backbone.paginator-2.0.2", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
            },
            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("It returns a function", function () {
            ok(typeof BackbonePaginatorFactory == "function");
        });

        test("It returns a copy of Backbone.Paginator 2.0.2", function () {
            var BackbonePaginator = BackbonePaginatorFactory(_, Backbone);

            ok(BackbonePaginator.VERSION == "2.0.2");
        });

        test("Each call returns a new copy", function () {
            var BackbonePaginator1 = BackbonePaginatorFactory(_, Backbone);
            var BackbonePaginator2 = BackbonePaginatorFactory(_, Backbone);

            ok(BackbonePaginator1 !== BackbonePaginator2);
        });

        test("It uses the provided Backbone", function () {
            var BackbonePaginator = BackbonePaginatorFactory(_, Backbone);

            var collection = new BackbonePaginator();
            ok(collection instanceof Backbone.Collection);
        });

        test("It uses the provided Underscore", function () {
            var BackbonePaginator = BackbonePaginatorFactory(_, Backbone);
            this.spy(_, "extend");

            var collection = new BackbonePaginator();
            sinon.assert.calledOnce(_.extend);
        });

        test("It does not pollute the Backbone namespace", function () {
            var BackbonePaginator = BackbonePaginatorFactory(_, Backbone);

            equal(typeof Backbone.PageableCollection, "undefined");
        });
    });
});
