AJS.test.require([
    "com.atlassian.plugin.jslibs:marionette-2.1.0-factory",
    "com.atlassian.plugin.jslibs:backbone-1.0.0-factory",
    "com.atlassian.plugin.jslibs:underscore-1.5.2"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/marionette-2.1.0",
        "atlassian/libs/factories/backbone-1.0.0",
        "atlassian/libs/underscore-1.5.2",
        "jquery"
    ], function (
        MarionetteFactory,
        BackboneFactory,
        _,
        $
    ) {
        var Backbone = BackboneFactory(_, $);

        module("atlassian/libs/factories/marionette-2.1.0", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
            },
            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("It returns a function", function () {
            ok(typeof MarionetteFactory == "function");
        });

        test("It returns a copy of Marionette 2.1.0", function () {
            var Marionette = MarionetteFactory(_, Backbone);

            ok(Marionette.VERSION == "2.1.0");
        });

        test("Each call returns a new copy", function () {
            var Marionette1 = MarionetteFactory(_, Backbone);
            var Marionette2 = MarionetteFactory(_, Backbone);

            ok(Marionette1 !== Marionette2);
        });

        test("It uses the provided Backbone", function () {
            this.spy(Backbone.Router, "extend");
            var Marionette = MarionetteFactory(_, Backbone);

            sinon.assert.calledOnce(Backbone.Router.extend);
        });

        test("It uses the provided Underscore", function () {
            var Marionette = MarionetteFactory(_, Backbone);
            this.spy(_, "result");

            var obj = new Marionette.Object();
            sinon.assert.calledOnce(_.result);
        });

        test("It does not pollute Backbone namespace", function () {
            var Marionette = MarionetteFactory(_, Backbone);

            ok(typeof Backbone.ChildViewContainer === "undefined");
            ok(typeof Backbone.Wreqr === "undefined");
        });
    });
});
