AJS.test.require([
    "com.atlassian.plugin.jslibs:backbone-1.3.3-factory",
    "com.atlassian.plugin.jslibs:underscore-1.8.3"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/backbone-1.3.3",
        "atlassian/libs/underscore-1.8.3",
        "jquery"
    ], function (
        BackboneFactory,
        _,
        $
    ) {
        module("atlassian/libs/factories/backbone-1.3.3");

        test("It returns a function", function () {
            ok(typeof BackboneFactory == "function");
        });

        test("It uses the provided Underscore", function () {
            this.spy(_, "extend");
            BackboneFactory(_, $);

            // Backbone uses _.extend() to construct itself
            sinon.assert.called(_.extend);
        });

        test("It uses the provided jQuery", function () {
            var Backbone = BackboneFactory(_, $);

            // Backbone exposes jQuery in Backbone.$
            strictEqual(Backbone.$, $);
        });

        test("It returns a copy of Backbone 1.3.3", function () {
            var Backbone = BackboneFactory(_, $);
            ok(typeof Backbone == "object");
            ok(Backbone.VERSION == "1.3.3");
        });

        test("Each call returns a new copy", function () {
            var Backbone1 = BackboneFactory(_, $);
            var Backbone2 = BackboneFactory(_, $);

            ok(Backbone1 !== Backbone2);
        });
    });
});
