/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core.vfs;

import com.atlassian.plugin.spring.scanner.core.vfs.CommonIO;
import com.atlassian.plugin.spring.scanner.core.vfs.VirtualFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;

class FileBasedVirtualFile
implements VirtualFile {
    private final File file;

    FileBasedVirtualFile(File file) {
        this.file = file;
    }

    @Override
    public Collection<String> readLines() throws IOException {
        FileReader reader;
        try {
            reader = new FileReader(this.file);
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
        return CommonIO.readLines(reader);
    }

    @Override
    public void writeLines(Iterable<String> lines) throws IOException {
        this.mkdirs(this.file);
        CommonIO.writeLines(new FileWriter(this.file), lines);
    }

    @Override
    public void writeProperties(Properties properties, String comment) throws IOException {
        this.mkdirs(this.file);
        CommonIO.writeProperties(new FileWriter(this.file), properties, comment);
    }

    private void mkdirs(File file) throws IOException {
        File parentDir = file.getParentFile();
        parentDir.mkdirs();
        if (!parentDir.exists()) {
            throw new IOException("Unable to create output directory " + String.valueOf(parentDir));
        }
    }
}

