/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.maven;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;

class ScannedDependencyArtifactBuilder {
    ScannedDependencyArtifactBuilder() {
    }

    static List<Artifact> buildScannedArtifacts(DependencyNode projectDependencyGraph, final List<Dependency> configuredScannedDependencies) {
        final ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        projectDependencyGraph.accept(new DependencyNodeVisitor(){

            public boolean visit(DependencyNode node) {
                return true;
            }

            public boolean endVisit(DependencyNode node) {
                Artifact artifact = node.getArtifact();
                Optional dependencyOption = ScannedDependencyArtifactBuilder.artifactInConfiguredList(artifact, configuredScannedDependencies);
                if (dependencyOption.isPresent()) {
                    artifacts.addAll(ScannedDependencyArtifactBuilder.findIncludedTransitiveDeps(node, (Dependency)dependencyOption.get()));
                }
                return true;
            }
        });
        return artifacts;
    }

    private static Optional<Dependency> artifactInConfiguredList(final Artifact artifact, List<Dependency> configuredScannedDependencies) {
        Predicate<Dependency> predicate = new Predicate<Dependency>(){

            public boolean apply(Dependency input) {
                if (!"*".equals(input.getArtifactId())) {
                    return input.getGroupId().equals(artifact.getGroupId()) && input.getArtifactId().equals(artifact.getArtifactId());
                }
                return input.getGroupId().equals(artifact.getGroupId());
            }
        };
        return Optional.fromNullable((Object)Iterables.find(configuredScannedDependencies, (Predicate)predicate, null));
    }

    private static List<Artifact> findIncludedTransitiveDeps(DependencyNode dependencyNode, final Dependency dependency) {
        DependencyNodeFilter includedDeps = new DependencyNodeFilter(){

            public boolean accept(DependencyNode node) {
                return !ScannedDependencyArtifactBuilder.isExcluded(node.getArtifact(), dependency.getExclusions());
            }
        };
        CollectingDependencyNodeVisitor collector = new CollectingDependencyNodeVisitor();
        FilteringDependencyNodeVisitor filterer = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collector, includedDeps);
        dependencyNode.accept((DependencyNodeVisitor)filterer);
        List nodes = collector.getNodes();
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)nodes, (Function)new Function<DependencyNode, Artifact>(){

            public Artifact apply(DependencyNode input) {
                return input.getArtifact();
            }
        }));
    }

    private static boolean isExcluded(Artifact artifact, List<Exclusion> exclusions) {
        for (Exclusion exclusion : exclusions) {
            if (!exclusion.getGroupId().equals(artifact.getGroupId()) || !exclusion.getArtifactId().equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }
}

