/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.users;

import com.atlassian.performance.tools.jiraactions.api.memories.User;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import com.atlassian.performance.tools.virtualusers.api.users.TimeControllingUserGenerator;
import com.atlassian.performance.tools.virtualusers.api.users.UserGenerator;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/users/TimeControllingUserGenerator;", "Lcom/atlassian/performance/tools/virtualusers/api/users/UserGenerator;", "targetTime", "Ljava/time/Duration;", "userGenerator", "(Ljava/time/Duration;Lcom/atlassian/performance/tools/virtualusers/api/users/UserGenerator;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "controlGenerationTime", "Lcom/atlassian/performance/tools/jiraactions/api/memories/User;", "thread", "Ljava/util/concurrent/ExecutorService;", "options", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "generateUser", "virtual-users"})
public final class TimeControllingUserGenerator
implements UserGenerator {
    private final Logger logger;
    private final Duration targetTime;
    private final UserGenerator userGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public User generateUser(@NotNull VirtualUserOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        ExecutorService thread2 = Executors.newSingleThreadExecutor(generateUser.thread.1.INSTANCE);
        try {
            ExecutorService executorService = thread2;
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"thread");
            User user = this.controlGenerationTime(executorService, options);
            return user;
        }
        finally {
            thread2.shutdownNow();
        }
    }

    private final User controlGenerationTime(ExecutorService thread2, VirtualUserOptions options) {
        Instant start2 = Instant.now();
        Future futureUser2 = thread2.submit((Callable)new Callable<User>(this, options){
            final /* synthetic */ TimeControllingUserGenerator this$0;
            final /* synthetic */ VirtualUserOptions $options;

            @NotNull
            public final User call() {
                return TimeControllingUserGenerator.access$getUserGenerator$p(this.this$0).generateUser(this.$options);
            }
            {
                this.this$0 = timeControllingUserGenerator;
                this.$options = virtualUserOptions;
            }
        });
        User user = (User)futureUser2.get(this.targetTime.getSeconds(), TimeUnit.SECONDS);
        Duration elapsed = Duration.between(start2, Instant.now());
        Duration remaining = this.targetTime.minus(elapsed);
        if (remaining.compareTo(Duration.ZERO) <= 0) {
            throw (Throwable)new Exception("We should have finished by now, we're " + remaining + " late");
        }
        this.logger.info("User generated in time, with " + remaining + " leeway");
        Thread.sleep(remaining.toMillis());
        User user2 = user;
        Intrinsics.checkExpressionValueIsNotNull((Object)user2, (String)"user");
        return user2;
    }

    public TimeControllingUserGenerator(@NotNull Duration targetTime, @NotNull UserGenerator userGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)targetTime, (String)"targetTime");
        Intrinsics.checkParameterIsNotNull((Object)userGenerator, (String)"userGenerator");
        this.targetTime = targetTime;
        this.userGenerator = userGenerator;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public static final /* synthetic */ UserGenerator access$getUserGenerator$p(TimeControllingUserGenerator $this) {
        return $this.userGenerator;
    }
}

