/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.browsers;

import com.atlassian.performance.tools.virtualusers.api.browsers.Browser;
import com.atlassian.performance.tools.virtualusers.api.browsers.ChromedriverRuntime;
import com.atlassian.performance.tools.virtualusers.api.browsers.CloseableRemoteWebDriver;
import com.atlassian.performance.tools.virtualusers.api.browsers.HeadlessChromeBrowser;
import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0011\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00072\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/browsers/GoogleChrome;", "Lcom/atlassian/performance/tools/virtualusers/api/browsers/Browser;", "()V", "driverRuntime", "Lcom/atlassian/performance/tools/virtualusers/api/browsers/ChromedriverRuntime;", "(Lcom/atlassian/performance/tools/virtualusers/api/browsers/ChromedriverRuntime;)V", "allowInsecureConnections", "", "(Lcom/atlassian/performance/tools/virtualusers/api/browsers/ChromedriverRuntime;Z)V", "logger", "Lorg/apache/logging/log4j/Logger;", "configure", "", "options", "Lorg/openqa/selenium/chrome/ChromeOptions;", "service", "Lorg/openqa/selenium/chrome/ChromeDriverService$Builder;", "start", "Lcom/atlassian/performance/tools/virtualusers/api/browsers/CloseableRemoteWebDriver;", "Lorg/openqa/selenium/remote/RemoteWebDriver;", "headless", "verboseLog", "Ljava/io/File;", "virtual-users"})
public class GoogleChrome
implements Browser {
    private final Logger logger;
    private final ChromedriverRuntime driverRuntime;
    private final boolean allowInsecureConnections;

    @Override
    @NotNull
    public CloseableRemoteWebDriver start() {
        ChromeOptions options = new ChromeOptions();
        if (this.allowInsecureConnections) {
            options.addArguments(new String[]{"--ignore-certificate-errors"});
        }
        this.logger.debug("Starting Chrome");
        this.driverRuntime.ensureRunning();
        System.setProperty("webdriver.http.factory", "apache");
        ChromeDriverService.Builder service = new ChromeDriverService.Builder();
        this.configure(options, service);
        ChromeDriver driver = new ChromeDriver((ChromeDriverService)service.build(), options);
        WebDriver.Window window = driver.manage().window();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"driver.manage().window()");
        window.setSize(new Dimension(1024, 768));
        return new CloseableRemoteWebDriver((RemoteWebDriver)driver);
    }

    protected void configure(@NotNull ChromeOptions options, @NotNull ChromeDriverService.Builder service) {
        ChromeOptions chromeOptions;
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        ChromeOptions $receiver = chromeOptions = options;
        boolean bl = false;
        $receiver.addArguments(new String[]{"--no-sandbox"});
        $receiver = chromeOptions;
        boolean bl2 = false;
        $receiver.addArguments(new String[]{"--disable-dev-shm-usage"});
        $receiver = chromeOptions;
        boolean bl3 = false;
        $receiver.addArguments(new String[]{"--disable-infobars"});
        chromeOptions.setExperimentalOption("prefs", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"credentials_enable_service", (Object)false)));
    }

    @Deprecated(message="Do not use.")
    @NotNull
    public final RemoteWebDriver start(boolean headless, @Nullable File verboseLog) {
        return new GoogleChrome(verboseLog, headless){
            final /* synthetic */ File $verboseLog;
            final /* synthetic */ boolean $headless;

            protected void configure(@NotNull ChromeOptions options, @NotNull ChromeDriverService.Builder service) {
                Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                if (this.$verboseLog != null) {
                    ((ChromeDriverService.Builder)service.withLogFile(this.$verboseLog)).withVerbose(true);
                }
                if (this.$headless) {
                    HeadlessChromeBrowser.Companion.setHeadless(options);
                }
                super.configure(options, service);
            }
            {
                this.$verboseLog = $captured_local_variable$0;
                this.$headless = $captured_local_variable$1;
            }
        }.start().getDriver();
    }

    public static /* synthetic */ RemoteWebDriver start$default(GoogleChrome googleChrome, boolean bl, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            file = null;
        }
        return googleChrome.start(bl, file);
    }

    public GoogleChrome() {
        Logger logger = LogManager.getLogger(GoogleChrome.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(GoogleChrome::class.java)");
        this.logger = logger;
        this.driverRuntime = new ChromedriverRuntime();
        this.allowInsecureConnections = false;
    }

    @Deprecated(message="Do not use.")
    public GoogleChrome(@NotNull ChromedriverRuntime driverRuntime) {
        Intrinsics.checkParameterIsNotNull((Object)driverRuntime, (String)"driverRuntime");
        Logger logger = LogManager.getLogger(GoogleChrome.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(GoogleChrome::class.java)");
        this.logger = logger;
        this.driverRuntime = driverRuntime;
        this.allowInsecureConnections = false;
    }

    @Deprecated(message="Do not use.")
    public GoogleChrome(@NotNull ChromedriverRuntime driverRuntime, boolean allowInsecureConnections) {
        Intrinsics.checkParameterIsNotNull((Object)driverRuntime, (String)"driverRuntime");
        Logger logger = LogManager.getLogger(GoogleChrome.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(GoogleChrome::class.java)");
        this.logger = logger;
        this.driverRuntime = driverRuntime;
        this.allowInsecureConnections = allowInsecureConnections;
    }
}

