/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.ssh;

import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.schmizz.sshj.connection.channel.direct.Session;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0003H\u0002J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/ssh/WaitingCommand;", "", "command", "Lnet/schmizz/sshj/connection/channel/direct/Session$Command;", "timeout", "Ljava/time/Duration;", "stdout", "Lorg/apache/logging/log4j/Level;", "stderr", "(Lnet/schmizz/sshj/connection/channel/direct/Session$Command;Ljava/time/Duration;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Level;)V", "waitForResult", "Lcom/atlassian/performance/tools/ssh/api/SshConnection$SshResult;", "readAndLog", "", "Ljava/io/InputStream;", "level", "readOutput", "Lcom/atlassian/performance/tools/ssh/WaitingCommand$SshjExecutedCommand;", "waitForCompletion", "", "Companion", "SshjExecutedCommand", "ssh"})
public final class WaitingCommand {
    private final Session.Command command;
    private final Duration timeout;
    private final Level stdout;
    private final Level stderr;
    private static final Logger LOG;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final SshConnection.SshResult waitForResult() {
        this.waitForCompletion(this.command, this.timeout);
        Integer n = this.command.getExitStatus();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"command.exitStatus");
        int n2 = n;
        InputStream inputStream = this.command.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"command.inputStream");
        String string = this.readAndLog(inputStream, this.stdout);
        InputStream inputStream2 = this.command.getErrorStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"command.errorStream");
        return new SshConnection.SshResult(n2, string, this.readAndLog(inputStream2, this.stderr));
    }

    private final void waitForCompletion(@NotNull Session.Command $receiver, Duration timeout) {
        Instant expectedEnd = Instant.now().plus(timeout);
        Duration extendedTime = timeout.multipliedBy(5L).dividedBy(4L);
        try {
            $receiver.join(extendedTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            SshjExecutedCommand output = this.readOutput($receiver);
            throw (Throwable)new Exception("SSH command failed to finish in extended time (" + extendedTime + "): " + output, e);
        }
        Instant actualEnd = Instant.now();
        if (actualEnd.isAfter(expectedEnd)) {
            Duration overtime = Duration.between(expectedEnd, actualEnd);
            throw (Throwable)new Exception("SSH command exceeded timeout " + timeout + " by " + overtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SshjExecutedCommand readOutput(@NotNull Session.Command $receiver) {
        Object object;
        try {
            String string;
            Object it2;
            SshjExecutedCommand sshjExecutedCommand;
            $receiver.close();
            InputStream inputStream = $receiver.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"this.inputStream");
            object = inputStream;
            SshjExecutedCommand sshjExecutedCommand2 = sshjExecutedCommand;
            SshjExecutedCommand sshjExecutedCommand3 = sshjExecutedCommand;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
            object = (Closeable)object3;
            object2 = null;
            try {
                it2 = (InputStreamReader)object;
                it2 = TextStreamsKt.readText((Reader)((Reader)it2));
            }
            catch (Throwable it2) {
                object2 = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object3 = it2;
            InputStream inputStream2 = $receiver.getErrorStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"this.errorStream");
            object = inputStream2;
            object2 = Charsets.UTF_8;
            Object object4 = new InputStreamReader((InputStream)object, (Charset)object2);
            object = (Closeable)object4;
            object2 = null;
            try {
                it2 = (InputStreamReader)object;
                string = TextStreamsKt.readText((Reader)((Reader)it2));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object4 = string;
            sshjExecutedCommand2((String)object3, (String)object4);
            object = sshjExecutedCommand3;
        }
        catch (Exception e) {
            LOG.error("Failed do close ssh channel. Can't get command output", (Throwable)e);
            object = new SshjExecutedCommand("<couldn't get command stdout>", "<couldn't get command stderr>");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readAndLog(@NotNull InputStream $receiver, Level level) {
        String string;
        Object object = $receiver;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)object, (Charset)object2);
        object2 = null;
        try {
            InputStreamReader it = (InputStreamReader)object;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        String output = string;
        object = output;
        if (!StringsKt.isBlank((CharSequence)object)) {
            LOG.log(level, output);
        }
        return output;
    }

    public WaitingCommand(@NotNull Session.Command command, @NotNull Duration timeout, @NotNull Level stdout, @NotNull Level stderr) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Intrinsics.checkParameterIsNotNull((Object)stdout, (String)"stdout");
        Intrinsics.checkParameterIsNotNull((Object)stderr, (String)"stderr");
        this.command = command;
        this.timeout = timeout;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LogManager.getLogger(Companion.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/ssh/WaitingCommand$SshjExecutedCommand;", "", "stdout", "", "stderr", "(Ljava/lang/String;Ljava/lang/String;)V", "getStderr", "()Ljava/lang/String;", "getStdout", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ssh"})
    private static final class SshjExecutedCommand {
        @NotNull
        private final String stdout;
        @NotNull
        private final String stderr;

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        public SshjExecutedCommand(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkParameterIsNotNull((Object)stdout, (String)"stdout");
            Intrinsics.checkParameterIsNotNull((Object)stderr, (String)"stderr");
            this.stdout = stdout;
            this.stderr = stderr;
        }

        @NotNull
        public final String component1() {
            return this.stdout;
        }

        @NotNull
        public final String component2() {
            return this.stderr;
        }

        @NotNull
        public final SshjExecutedCommand copy(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkParameterIsNotNull((Object)stdout, (String)"stdout");
            Intrinsics.checkParameterIsNotNull((Object)stderr, (String)"stderr");
            return new SshjExecutedCommand(stdout, stderr);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SshjExecutedCommand copy$default(SshjExecutedCommand sshjExecutedCommand, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = sshjExecutedCommand.stdout;
            }
            if ((n & 2) != 0) {
                string2 = sshjExecutedCommand.stderr;
            }
            return sshjExecutedCommand.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "SshjExecutedCommand(stdout=" + this.stdout + ", stderr=" + this.stderr + ")";
        }

        public int hashCode() {
            String string = this.stdout;
            String string2 = this.stderr;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SshjExecutedCommand)) break block3;
                    SshjExecutedCommand sshjExecutedCommand = (SshjExecutedCommand)object;
                    if (!Intrinsics.areEqual((Object)this.stdout, (Object)sshjExecutedCommand.stdout) || !Intrinsics.areEqual((Object)this.stderr, (Object)sshjExecutedCommand.stderr)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/performance/tools/ssh/WaitingCommand$Companion;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "ssh"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

