/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.ssh;

import com.atlassian.performance.tools.ssh.WaitingCommand;
import com.atlassian.performance.tools.ssh.api.BackgroundProcess;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.connection.channel.direct.Session;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/ssh/SshjBackgroundProcess;", "Lcom/atlassian/performance/tools/ssh/api/BackgroundProcess;", "session", "Lnet/schmizz/sshj/connection/channel/direct/Session;", "command", "Lnet/schmizz/sshj/connection/channel/direct/Session$Command;", "(Lnet/schmizz/sshj/connection/channel/direct/Session;Lnet/schmizz/sshj/connection/channel/direct/Session$Command;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "close", "", "sendSigint", "stop", "Lcom/atlassian/performance/tools/ssh/api/SshConnection$SshResult;", "timeout", "Ljava/time/Duration;", "tryToInterrupt", "Companion", "ssh"})
public final class SshjBackgroundProcess
implements BackgroundProcess {
    private AtomicBoolean closed;
    private final Session session;
    private final Session.Command command;
    private static final Logger LOG;
    @Deprecated
    public static final Companion Companion;

    @Override
    @NotNull
    public SshConnection.SshResult stop(@NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        this.tryToInterrupt();
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        Level level2 = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.DEBUG");
        SshConnection.SshResult result = new WaitingCommand(this.command, timeout, level, level2).waitForResult();
        this.close();
        return result;
    }

    private final void tryToInterrupt() {
        try {
            this.sendSigint();
        }
        catch (Exception e) {
            LOG.debug("cannot interrupt, if the command doesn't run anymore, then the write connection is closed", (Throwable)e);
        }
    }

    private final void sendSigint() {
        int ctrlC = 3;
        this.command.getOutputStream().write(ctrlC);
        this.command.getOutputStream().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            Session.Command it2;
            Closeable closeable = (Closeable)this.command;
            Throwable throwable = null;
            try {
                it2 = (Session.Command)closeable;
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = (Closeable)this.session;
            throwable = null;
            try {
                it2 = (Session)closeable;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public SshjBackgroundProcess(@NotNull Session session, @NotNull Session.Command command) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.session = session;
        this.command = command;
        this.closed = new AtomicBoolean(false);
    }

    static {
        Companion = new Companion(null);
        LOG = LogManager.getLogger(Companion.getClass());
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/performance/tools/ssh/SshjBackgroundProcess$Companion;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "ssh"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

