/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.testutils.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jmc.flightrecorder.testutils.parser.ChunkHeader;
import org.openjdk.jmc.flightrecorder.testutils.parser.ChunkParserListener;
import org.openjdk.jmc.flightrecorder.testutils.parser.EventHeader;
import org.openjdk.jmc.flightrecorder.testutils.parser.MetadataEvent;
import org.openjdk.jmc.flightrecorder.testutils.parser.RecordingStream;

public final class StreamingChunkParser {
    private final ChunkParserListener listener;

    public StreamingChunkParser(ChunkParserListener listener) {
        this.listener = listener;
    }

    public void parse(Path inputFile) throws IOException {
        try (RecordingStream stream = new RecordingStream(new BufferedInputStream(Files.newInputStream(inputFile.toFile().toPath(), new OpenOption[0])));){
            this.parse(inputFile, stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(Path inputFile, RecordingStream stream) throws IOException {
        if (stream.available() == 0) {
            return;
        }
        try (RecordingFile jdkRecording = new RecordingFile(inputFile);){
            this.listener.onRecordingStart();
            int chunkCounter = 1;
            while (stream.available() > 0) {
                long chunkStartPos = stream.position();
                ChunkHeader header = ChunkHeader.read(stream);
                this.listener.onChunkStart(chunkCounter, header);
                long chunkEndPos = chunkStartPos + (long)((int)header.size);
                while (stream.position() < chunkEndPos) {
                    long eventStartPos = stream.position();
                    stream.startRecordingWrites();
                    int eventSize = (int)stream.readVarint();
                    if (eventSize > 0) {
                        this.parseEvent(stream, eventSize, eventStartPos, jdkRecording);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected event size: " + eventSize + " at position " + stream.position());
                }
                this.listener.onChunkEnd(chunkCounter, false);
                ++chunkCounter;
            }
        }
        finally {
            this.listener.onRecordingEnd();
        }
    }

    private void parseEvent(RecordingStream stream, int eventSize, long eventStartPos, RecordingFile jdkRecording) throws IOException {
        long eventType = stream.readVarint();
        EventHeader eventHeader = new EventHeader(eventSize, eventType, stream.stopRecordingWrites());
        byte[] eventPayload = this.getBytes(stream, eventSize, eventStartPos);
        if (eventType == 0L) {
            MetadataEvent metadata = new MetadataEvent(new RecordingStream(new ByteArrayInputStream(eventPayload)), eventSize, eventType);
            this.listener.onMetadata(eventHeader, eventPayload, metadata);
        } else if (eventType == 1L) {
            this.listener.onCheckpoint(eventHeader, eventPayload);
        } else {
            RecordedEvent jdkEvent = jdkRecording.readEvent();
            this.listener.onEvent(jdkEvent, eventHeader, eventPayload);
        }
        stream.skip((long)eventSize - (stream.position() - eventStartPos));
    }

    @NotNull
    private byte[] getBytes(RecordingStream stream, int eventSize, long eventStartPos) throws IOException {
        long currentPos = stream.position();
        int payloadSize = (int)((long)eventSize - (currentPos - eventStartPos));
        byte[] eventPayload = new byte[payloadSize];
        stream.read(eventPayload, 0, payloadSize);
        return eventPayload;
    }
}

