/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.testutils.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class RecordingStream
implements AutoCloseable {
    private final DataInputStream delegate;
    private long position = 0L;
    private final ByteArrayOutputStream toBytesLog = new ByteArrayOutputStream();
    private DataOutputStream toBytesStream = new DataOutputStream(this.toBytesLog);
    private boolean isRecordingWrites = false;

    public RecordingStream(InputStream is) {
        BufferedInputStream bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        this.delegate = new DataInputStream(bis);
    }

    long position() {
        return this.position;
    }

    void startRecordingWrites() {
        this.isRecordingWrites = true;
    }

    public byte[] stopRecordingWrites() {
        this.isRecordingWrites = false;
        byte[] result = this.toBytesLog.toByteArray();
        this.toBytesLog.reset();
        return result;
    }

    public void read(byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int read = this.delegate.read(buffer, offset, length);
            if (read == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (this.isRecordingWrites) {
                this.toBytesStream.write(buffer, offset, read);
            }
            offset += read;
            length -= read;
            this.position += (long)read;
        }
    }

    public byte read() throws IOException {
        ++this.position;
        byte result = this.delegate.readByte();
        if (this.isRecordingWrites) {
            this.toBytesStream.writeByte(result);
        }
        return result;
    }

    short readShort() throws IOException {
        this.position += 2L;
        short result = this.delegate.readShort();
        if (this.isRecordingWrites) {
            this.toBytesStream.writeShort(result);
        }
        return result;
    }

    public int readInt() throws IOException {
        this.position += 4L;
        int result = this.delegate.readInt();
        if (this.isRecordingWrites) {
            this.toBytesStream.writeInt(this.delegate.readInt());
        }
        return result;
    }

    long readLong() throws IOException {
        this.position += 8L;
        long result = this.delegate.readLong();
        if (this.isRecordingWrites) {
            this.toBytesStream.writeLong(result);
        }
        return result;
    }

    public long readVarint() throws IOException {
        long value = 0L;
        int readValue = 0;
        int i = 0;
        do {
            readValue = this.delegate.read();
            if (this.isRecordingWrites) {
                this.toBytesStream.writeByte(readValue);
            }
            value |= (long)(readValue & 0x7F) << 7 * i;
        } while ((readValue & 0x80) != 0 && ++i < 9);
        this.position += (long)i;
        return value;
    }

    public int available() throws IOException {
        return this.delegate.available();
    }

    void skip(long bytes) throws IOException {
        for (long toSkip = bytes; toSkip > 0L; toSkip -= this.delegate.skip(toSkip)) {
        }
        this.position += bytes;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

