/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.testutils.parser;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openjdk.jmc.flightrecorder.testutils.parser.RecordingStream;

public final class MetadataEvent {
    private static final byte[] COMMON_BUFFER = new byte[4096];
    public final int size;
    public final long startTime;
    public final long duration;
    public final long metadataId;
    private int gmtOffset = 1;
    private final Map<Long, String> eventTypeNameMapBacking = new HashMap<Long, String>(256);

    MetadataEvent(RecordingStream stream, int eventSize, long eventType) throws IOException {
        this.size = eventSize;
        if (eventType != 0L) {
            throw new IOException("Unexpected event type: " + eventType + " (should be 0). Stream at position: " + stream.position());
        }
        this.startTime = stream.readVarint();
        this.duration = stream.readVarint();
        this.metadataId = stream.readVarint();
        this.readElements(stream, this.readStringTable(stream));
    }

    private MetadataEvent(int size, long startTime, long duration, long metadataId, Map<Long, String> eventTypeNameMapBacking) {
        this.size = size;
        this.startTime = startTime;
        this.duration = duration;
        this.metadataId = metadataId;
        this.eventTypeNameMapBacking.putAll(eventTypeNameMapBacking);
    }

    public int getGmtOffset() {
        return this.gmtOffset;
    }

    private String[] readStringTable(RecordingStream stream) throws IOException {
        int stringCnt = (int)stream.readVarint();
        String[] stringConstants = new String[stringCnt];
        for (int stringIdx = 0; stringIdx < stringCnt; ++stringIdx) {
            stringConstants[stringIdx] = this.readUTF8(stream);
        }
        return stringConstants;
    }

    private void readElements(RecordingStream stream, String[] stringConstants) throws IOException {
        int stringPtr = (int)stream.readVarint();
        boolean isClassElement = "class".equals(stringConstants[stringPtr]);
        int attrCount = (int)stream.readVarint();
        String superType = null;
        String name = null;
        String id = null;
        for (int i = 0; i < attrCount; ++i) {
            int keyPtr = (int)stream.readVarint();
            int valPtr = (int)stream.readVarint();
            if ("gmtOffset".equals(stringConstants[keyPtr])) {
                this.gmtOffset = Integer.parseInt(stringConstants[valPtr]);
            }
            if (!isClassElement) continue;
            if ("superType".equals(stringConstants[keyPtr])) {
                superType = stringConstants[valPtr];
                continue;
            }
            if ("name".equals(stringConstants[keyPtr])) {
                name = stringConstants[valPtr];
                continue;
            }
            if (!"id".equals(stringConstants[keyPtr])) continue;
            id = stringConstants[valPtr];
        }
        if (name != null && id != null && "jdk.jfr.Event".equals(superType)) {
            this.eventTypeNameMapBacking.put(Long.parseLong(id), name);
        }
        int elemCount = (int)stream.readVarint();
        for (int i = 0; i < elemCount; ++i) {
            this.readElements(stream, stringConstants);
        }
    }

    private String readUTF8(RecordingStream stream) throws IOException {
        byte id = stream.read();
        if (id == 0) {
            return null;
        }
        if (id == 1) {
            return "";
        }
        if (id == 3) {
            int size = (int)stream.readVarint();
            byte[] content = size <= COMMON_BUFFER.length ? COMMON_BUFFER : new byte[size];
            stream.read(content, 0, size);
            return new String(content, 0, size, StandardCharsets.UTF_8);
        }
        if (id == 4) {
            int size = (int)stream.readVarint();
            char[] chars = new char[size];
            for (int i = 0; i < size; ++i) {
                chars[i] = (char)stream.readVarint();
            }
            return new String(chars);
        }
        throw new IOException("Unexpected string constant id: " + id + ". Stream at position " + stream.position() + ", " + this);
    }

    public String toString() {
        return "Metadata{size=" + this.size + ", startTime=" + this.startTime + ", duration=" + this.duration + ", metadataId=" + this.metadataId + "}" + this.eventTypeNameMapBacking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataEvent that = (MetadataEvent)o;
        return this.size == that.size && this.startTime == that.startTime && this.duration == that.duration && this.metadataId == that.metadataId;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.startTime, this.duration, this.metadataId);
    }

    public static class Builder {
        private int size;
        private long startTime;
        private long duration;
        private long metadataId;
        private Map<Long, String> eventTypeNameMapBacking = new HashMap<Long, String>(256);

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder metadataId(long metadataId) {
            this.metadataId = metadataId;
            return this;
        }

        public Builder eventTypeNameMapBacking(Map<Long, String> eventTypeNameMapBacking) {
            this.eventTypeNameMapBacking.putAll(eventTypeNameMapBacking);
            return this;
        }

        public MetadataEvent build() {
            return new MetadataEvent(this.size, this.startTime, this.duration, this.metadataId, this.eventTypeNameMapBacking);
        }
    }
}

