/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.jstat;

import com.atlassian.performance.tools.infrastructure.api.metric.Dimension;
import com.atlassian.performance.tools.infrastructure.api.metric.SystemMetric;
import com.atlassian.performance.tools.report.jstat.JstatGcutilHeader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/report/jstat/JstatGcutilParser;", "", "()V", "parse", "", "Lcom/atlassian/performance/tools/infrastructure/api/metric/SystemMetric;", "inputStream", "Ljava/io/InputStream;", "system", "", "parse$report", "JstatMetric", "report"})
public final class JstatGcutilParser {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SystemMetric> parse$report(@NotNull InputStream inputStream, @NotNull String system) {
        void $receiver$iv$iv;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        CSVParser cSVParser;
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)system, (String)"system");
        InputStream inputStream2 = inputStream;
        Object object = cSVParser;
        Object object2 = cSVParser;
        Object object3 = Charsets.UTF_8;
        Closeable closeable = inputStream2;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object3);
        int n = 8192;
        BufferedReader bufferedReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        object((Reader)bufferedReader, CSVFormat.DEFAULT.withFirstRecordAsHeader());
        CSVParser parser = object2;
        object3 = CollectionsKt.toList((Iterable)((Iterable)parser));
        void var6_12 = $receiver$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void record;
            CSVRecord cSVRecord = (CSVRecord)item$iv$iv;
            object2 = destination$iv$iv;
            void v1 = record;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"record");
            object = new JstatMetric((CSVRecord)v1, system);
            object2.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new Comparator<T>(){

            public final int compare(T a, T b) {
                JstatMetric it = (JstatMetric)a;
                Comparable comparable = it.getStart();
                it = (JstatMetric)b;
                Comparable comparable2 = comparable;
                Instant instant = it.getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)instant);
            }
        };
        List sortedJstatMetrics = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv2, (Comparator)destination$iv$iv);
        CSVRecord last = null;
        Iterable $receiver$iv2 = sortedJstatMetrics;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JstatMetric it = (JstatMetric)element$iv$iv;
            List<SystemMetric> systemMetrics = it.toSystemMetrics(last);
            last = it.getRecord();
            Iterable list$iv$iv = systemMetrics;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/report/jstat/JstatGcutilParser$JstatMetric;", "", "record", "Lorg/apache/commons/csv/CSVRecord;", "system", "", "(Lorg/apache/commons/csv/CSVRecord;Ljava/lang/String;)V", "getRecord", "()Lorg/apache/commons/csv/CSVRecord;", "start", "Ljava/time/Instant;", "getStart", "()Ljava/time/Instant;", "metric", "Lcom/atlassian/performance/tools/infrastructure/api/metric/SystemMetric;", "dimension", "Lcom/atlassian/performance/tools/infrastructure/api/metric/Dimension;", "value", "", "toSystemMetrics", "", "previous", "report"})
    private static final class JstatMetric {
        @NotNull
        private final Instant start;
        @NotNull
        private final CSVRecord record;
        private final String system;

        @NotNull
        public final Instant getStart() {
            return this.start;
        }

        @NotNull
        public final List<SystemMetric> toSystemMetrics(@Nullable CSVRecord previous) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            Object[] objectArray = new SystemMetric[11];
            String string = this.record.get((Enum)JstatGcutilHeader.S0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"record.get(JstatGcutilHeader.S0)");
            String string2 = string;
            Dimension dimension = Dimension.JSTAT_SURVI_0;
            JstatMetric jstatMetric = this;
            int n = 0;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            double d6 = Double.parseDouble(string2);
            objectArray2[n] = jstatMetric.metric(dimension, d6);
            String string3 = this.record.get((Enum)JstatGcutilHeader.S1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"record.get(JstatGcutilHeader.S1)");
            string2 = string3;
            dimension = Dimension.JSTAT_SURVI_1;
            jstatMetric = this;
            n = 1;
            objectArray2 = objectArray3;
            d6 = Double.parseDouble(string2);
            objectArray2[n] = jstatMetric.metric(dimension, d6);
            String string4 = this.record.get((Enum)JstatGcutilHeader.E);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"record.get(JstatGcutilHeader.E)");
            string2 = string4;
            dimension = Dimension.JSTAT_EDEN;
            jstatMetric = this;
            n = 2;
            objectArray2 = objectArray3;
            d6 = Double.parseDouble(string2);
            objectArray2[n] = jstatMetric.metric(dimension, d6);
            String string5 = this.record.get((Enum)JstatGcutilHeader.O);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"record.get(JstatGcutilHeader.O)");
            string2 = string5;
            dimension = Dimension.JSTAT_OLD;
            jstatMetric = this;
            n = 3;
            objectArray2 = objectArray3;
            d6 = Double.parseDouble(string2);
            objectArray2[n] = jstatMetric.metric(dimension, d6);
            String string6 = this.record.get((Enum)JstatGcutilHeader.M);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"record.get(JstatGcutilHeader.M)");
            string2 = string6;
            dimension = Dimension.JSTAT_META;
            jstatMetric = this;
            n = 4;
            objectArray2 = objectArray3;
            d6 = Double.parseDouble(string2);
            objectArray2[n] = jstatMetric.metric(dimension, d6);
            String string7 = this.record.get((Enum)JstatGcutilHeader.CCS);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"record.get(JstatGcutilHeader.CCS)");
            string2 = string7;
            dimension = Dimension.JSTAT_COMPRESSED_CLASS;
            jstatMetric = this;
            n = 5;
            objectArray2 = objectArray3;
            d6 = Double.parseDouble(string2);
            objectArray2[n] = jstatMetric.metric(dimension, d6);
            String string8 = this.record.get((Enum)JstatGcutilHeader.YGC);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"record.get(JstatGcutilHeader.YGC)");
            string2 = string8;
            dimension = Dimension.JSTAT_YOUNG_GEN_GC;
            jstatMetric = this;
            n = 6;
            objectArray2 = objectArray3;
            d6 = Double.parseDouble(string2);
            Object[] objectArray4 = objectArray3;
            Object[] objectArray5 = objectArray2;
            int n2 = n;
            JstatMetric jstatMetric2 = jstatMetric;
            Dimension dimension2 = dimension;
            double d7 = d6;
            Object object = previous;
            if (object != null && (object = object.get((Enum)JstatGcutilHeader.YGC)) != null) {
                string2 = object;
                d6 = d7;
                dimension = dimension2;
                jstatMetric = jstatMetric2;
                n = n2;
                objectArray2 = objectArray5;
                objectArray3 = objectArray4;
                d5 = Double.parseDouble(string2);
                objectArray4 = objectArray3;
                objectArray5 = objectArray2;
                n2 = n;
                jstatMetric2 = jstatMetric;
                dimension2 = dimension;
                d7 = d6;
                d4 = d5;
            } else {
                d4 = 0.0;
            }
            objectArray5[n2] = jstatMetric2.metric(dimension2, d7 - d4);
            String string9 = this.record.get((Enum)JstatGcutilHeader.YGCT);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"record.get(JstatGcutilHeader.YGCT)");
            string2 = string9;
            dimension = Dimension.JSTAT_YOUNG_GEN_GC_TIME;
            jstatMetric = this;
            n = 7;
            objectArray2 = objectArray4;
            objectArray3 = objectArray4;
            d6 = Double.parseDouble(string2);
            Object[] objectArray6 = objectArray3;
            Object[] objectArray7 = objectArray2;
            int n3 = n;
            JstatMetric jstatMetric3 = jstatMetric;
            Dimension dimension3 = dimension;
            double d8 = d6;
            Object object2 = previous;
            if (object2 != null && (object2 = object2.get((Enum)JstatGcutilHeader.YGCT)) != null) {
                string2 = object2;
                d6 = d8;
                dimension = dimension3;
                jstatMetric = jstatMetric3;
                n = n3;
                objectArray2 = objectArray7;
                objectArray3 = objectArray6;
                d5 = Double.parseDouble(string2);
                objectArray6 = objectArray3;
                objectArray7 = objectArray2;
                n3 = n;
                jstatMetric3 = jstatMetric;
                dimension3 = dimension;
                d8 = d6;
                d3 = d5;
            } else {
                d3 = 0.0;
            }
            objectArray7[n3] = jstatMetric3.metric(dimension3, d8 - d3);
            String string10 = this.record.get((Enum)JstatGcutilHeader.FGC);
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"record.get(JstatGcutilHeader.FGC)");
            string2 = string10;
            dimension = Dimension.JSTAT_FULL_GC;
            jstatMetric = this;
            n = 8;
            objectArray2 = objectArray6;
            objectArray3 = objectArray6;
            d6 = Double.parseDouble(string2);
            Object[] objectArray8 = objectArray3;
            Object[] objectArray9 = objectArray2;
            int n4 = n;
            JstatMetric jstatMetric4 = jstatMetric;
            Dimension dimension4 = dimension;
            double d9 = d6;
            Object object3 = previous;
            if (object3 != null && (object3 = object3.get((Enum)JstatGcutilHeader.FGC)) != null) {
                string2 = object3;
                d6 = d9;
                dimension = dimension4;
                jstatMetric = jstatMetric4;
                n = n4;
                objectArray2 = objectArray9;
                objectArray3 = objectArray8;
                d5 = Double.parseDouble(string2);
                objectArray8 = objectArray3;
                objectArray9 = objectArray2;
                n4 = n;
                jstatMetric4 = jstatMetric;
                dimension4 = dimension;
                d9 = d6;
                d2 = d5;
            } else {
                d2 = 0.0;
            }
            objectArray9[n4] = jstatMetric4.metric(dimension4, d9 - d2);
            String string11 = this.record.get((Enum)JstatGcutilHeader.FGCT);
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"record.get(JstatGcutilHeader.FGCT)");
            string2 = string11;
            dimension = Dimension.JSTAT_FULL_GC_TIME;
            jstatMetric = this;
            n = 9;
            objectArray2 = objectArray8;
            objectArray3 = objectArray8;
            d6 = Double.parseDouble(string2);
            Object[] objectArray10 = objectArray3;
            Object[] objectArray11 = objectArray2;
            int n5 = n;
            JstatMetric jstatMetric5 = jstatMetric;
            Dimension dimension5 = dimension;
            double d10 = d6;
            Object object4 = previous;
            if (object4 != null && (object4 = object4.get((Enum)JstatGcutilHeader.FGCT)) != null) {
                string2 = object4;
                d6 = d10;
                dimension = dimension5;
                jstatMetric = jstatMetric5;
                n = n5;
                objectArray2 = objectArray11;
                objectArray3 = objectArray10;
                d5 = Double.parseDouble(string2);
                objectArray10 = objectArray3;
                objectArray11 = objectArray2;
                n5 = n;
                jstatMetric5 = jstatMetric;
                dimension5 = dimension;
                d10 = d6;
                d = d5;
            } else {
                d = 0.0;
            }
            objectArray11[n5] = jstatMetric5.metric(dimension5, d10 - d);
            String string12 = this.record.get((Enum)JstatGcutilHeader.GCT);
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"record.get(JstatGcutilHeader.GCT)");
            string2 = string12;
            dimension = Dimension.JSTAT_TOTAL_GC_TIME;
            jstatMetric = this;
            n = 10;
            objectArray2 = objectArray10;
            objectArray3 = objectArray10;
            d6 = Double.parseDouble(string2);
            objectArray2[n] = jstatMetric.metric(dimension, d6);
            return CollectionsKt.listOf((Object[])objectArray3);
        }

        private final SystemMetric metric(Dimension dimension, double value) {
            return new SystemMetric(this.start, dimension, value, this.system);
        }

        @NotNull
        public final CSVRecord getRecord() {
            return this.record;
        }

        public JstatMetric(@NotNull CSVRecord record, @NotNull String system) {
            Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
            Intrinsics.checkParameterIsNotNull((Object)system, (String)"system");
            this.record = record;
            this.system = system;
            Instant instant = OffsetDateTime.parse(this.record.get((Enum)JstatGcutilHeader.DATE)).toInstant();
            if (instant == null) {
                Intrinsics.throwNpe();
            }
            this.start = instant;
        }
    }
}

