/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.jfr;

import com.atlassian.performance.tools.report.jfr.CountingOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.function.Predicate;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jmc.flightrecorder.testutils.parser.ChunkHeader;
import org.openjdk.jmc.flightrecorder.testutils.parser.ChunkParserListener;
import org.openjdk.jmc.flightrecorder.testutils.parser.EventHeader;
import org.openjdk.jmc.flightrecorder.testutils.parser.MetadataEvent;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0010H\u0016J \u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0017H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/atlassian/performance/tools/report/jfr/FilteringJfrWriter;", "Lorg/openjdk/jmc/flightrecorder/testutils/parser/ChunkParserListener;", "outputFile", "Ljava/io/File;", "output", "Ljava/io/OutputStream;", "eventFilter", "Ljava/util/function/Predicate;", "Ljdk/jfr/consumer/RecordedEvent;", "(Ljava/io/File;Ljava/io/OutputStream;Ljava/util/function/Predicate;)V", "absoluteChunkStartPos", "", "countingOutput", "Lcom/atlassian/performance/tools/report/jfr/CountingOutputStream;", "lastCheckpointEventOffset", "lastHeader", "Lorg/openjdk/jmc/flightrecorder/testutils/parser/ChunkHeader;", "lastMetadataEventOffset", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Ljava/io/DataOutputStream;", "onCheckpoint", "", "eventHeader", "Lorg/openjdk/jmc/flightrecorder/testutils/parser/EventHeader;", "eventPayload", "", "onChunkEnd", "chunkIndex", "", "skipped", "", "onChunkStart", "header", "onEvent", "event", "onMetadata", "metadataPayload", "metadata", "Lorg/openjdk/jmc/flightrecorder/testutils/parser/MetadataEvent;", "updateChunk", "report"})
public final class FilteringJfrWriter
implements ChunkParserListener {
    private final Logger logger;
    private final CountingOutputStream countingOutput;
    private final DataOutputStream output;
    private ChunkHeader lastHeader;
    private long lastMetadataEventOffset;
    private long lastCheckpointEventOffset;
    private long absoluteChunkStartPos;
    private final File outputFile;
    private final Predicate<RecordedEvent> eventFilter;

    @Override
    public void onChunkStart(int chunkIndex, @NotNull ChunkHeader header) {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        this.lastHeader = header;
        this.absoluteChunkStartPos = this.countingOutput.getCount();
        header.write(this.output);
    }

    @Override
    public void onMetadata(@NotNull EventHeader eventHeader, @NotNull byte[] metadataPayload, @NotNull MetadataEvent metadata) {
        Intrinsics.checkParameterIsNotNull((Object)eventHeader, (String)"eventHeader");
        Intrinsics.checkParameterIsNotNull((Object)metadataPayload, (String)"metadataPayload");
        Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
        this.lastMetadataEventOffset = this.countingOutput.getCountSinceLastReset();
        this.output.write(eventHeader.bytes);
        this.output.write(metadataPayload);
    }

    @Override
    public void onEvent(@NotNull RecordedEvent event, @NotNull EventHeader eventHeader, @NotNull byte[] eventPayload) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)eventHeader, (String)"eventHeader");
        Intrinsics.checkParameterIsNotNull((Object)eventPayload, (String)"eventPayload");
        if (this.eventFilter.test(event)) {
            this.output.write(eventHeader.bytes);
            this.output.write(eventPayload);
        }
    }

    @Override
    public void onCheckpoint(@NotNull EventHeader eventHeader, @NotNull byte[] eventPayload) {
        Intrinsics.checkParameterIsNotNull((Object)eventHeader, (String)"eventHeader");
        Intrinsics.checkParameterIsNotNull((Object)eventPayload, (String)"eventPayload");
        this.lastCheckpointEventOffset = this.countingOutput.getCountSinceLastReset();
        this.output.write(eventHeader.bytes);
        this.output.write(eventPayload);
    }

    @Override
    public void onChunkEnd(int chunkIndex, boolean skipped) {
        this.updateChunk();
        this.countingOutput.resetCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateChunk() {
        this.output.flush();
        ChunkHeader chunkHeader = this.lastHeader;
        if (chunkHeader == null) {
            Intrinsics.throwNpe();
        }
        ChunkHeader currentHeader = chunkHeader;
        ChunkHeader updatedHeader = currentHeader.toBuilder().size(this.countingOutput.getCount() - this.absoluteChunkStartPos).cpOffset(this.lastCheckpointEventOffset).metaOffset(this.lastMetadataEventOffset).build();
        Closeable closeable = new RandomAccessFile(this.outputFile, "rw");
        Throwable throwable = null;
        try {
            ChunkHeader chunkHeader2;
            RandomAccessFile it = (RandomAccessFile)closeable;
            it.seek(this.absoluteChunkStartPos);
            ChunkHeader $receiver = chunkHeader2 = updatedHeader;
            this.logger.debug("Updating chunk to " + $receiver);
            $receiver.write(it);
            ChunkHeader chunkHeader3 = chunkHeader2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public FilteringJfrWriter(@NotNull File outputFile, @NotNull OutputStream output, @NotNull Predicate<RecordedEvent> eventFilter2) {
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(eventFilter2, (String)"eventFilter");
        this.outputFile = outputFile;
        this.eventFilter = eventFilter2;
        this.logger = LogManager.getLogger(this.getClass());
        this.countingOutput = new CountingOutputStream(output);
        this.output = new DataOutputStream(this.countingOutput);
    }
}

