/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.distribution;

import com.atlassian.performance.tools.report.Point;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J#\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/performance/tools/report/distribution/RelativeFrequency;", "Lcom/atlassian/performance/tools/report/Point;", "", "valueRange", "Lkotlin/ranges/ClosedRange;", "", "frequency", "(Lkotlin/ranges/ClosedRange;D)V", "getFrequency", "()D", "getValueRange", "()Lkotlin/ranges/ClosedRange;", "x", "getX", "()Ljava/lang/Integer;", "y", "Ljava/math/BigDecimal;", "getY", "()Ljava/math/BigDecimal;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "labelX", "", "toString", "report"})
public final class RelativeFrequency
implements Point<Integer> {
    private final int x;
    @NotNull
    private final BigDecimal y;
    @NotNull
    private final ClosedRange<Double> valueRange;
    private final double frequency;

    @Override
    @NotNull
    public Integer getX() {
        return this.x;
    }

    @Override
    @NotNull
    public BigDecimal getY() {
        return this.y;
    }

    @Override
    @NotNull
    public String labelX() {
        return "" + (int)((Number)((Object)this.valueRange.getStart())).doubleValue() + '-' + (int)((Number)((Object)this.valueRange.getEndInclusive())).doubleValue();
    }

    @NotNull
    public final ClosedRange<Double> getValueRange() {
        return this.valueRange;
    }

    public final double getFrequency() {
        return this.frequency;
    }

    public RelativeFrequency(@NotNull ClosedRange<Double> valueRange, double frequency) {
        Intrinsics.checkParameterIsNotNull(valueRange, (String)"valueRange");
        this.valueRange = valueRange;
        this.frequency = frequency;
        this.x = (int)CollectionsKt.averageOfDouble((Iterable)CollectionsKt.listOf((Object[])new Double[]{(Double)this.valueRange.getStart(), (Double)this.valueRange.getEndInclusive()}));
        double d = this.frequency * (double)100;
        RelativeFrequency relativeFrequency = this;
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        BigDecimal bigDecimal2 = bigDecimal.setScale(2, RoundingMode.HALF_UP);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"(frequency * 100)\n      \u2026(2, RoundingMode.HALF_UP)");
        relativeFrequency.y = bigDecimal2;
    }

    @NotNull
    public final ClosedRange<Double> component1() {
        return this.valueRange;
    }

    public final double component2() {
        return this.frequency;
    }

    @NotNull
    public final RelativeFrequency copy(@NotNull ClosedRange<Double> valueRange, double frequency) {
        Intrinsics.checkParameterIsNotNull(valueRange, (String)"valueRange");
        return new RelativeFrequency(valueRange, frequency);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ RelativeFrequency copy$default(RelativeFrequency relativeFrequency, ClosedRange closedRange, double d, int n, Object object) {
        if ((n & 1) != 0) {
            closedRange = relativeFrequency.valueRange;
        }
        if ((n & 2) != 0) {
            d = relativeFrequency.frequency;
        }
        return relativeFrequency.copy(closedRange, d);
    }

    @NotNull
    public String toString() {
        return "RelativeFrequency(valueRange=" + this.valueRange + ", frequency=" + this.frequency + ")";
    }

    public int hashCode() {
        ClosedRange<Double> closedRange = this.valueRange;
        long l = Double.doubleToLongBits(this.frequency);
        return (closedRange != null ? closedRange.hashCode() : 0) * 31 + (int)(l ^ l >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RelativeFrequency)) break block3;
                RelativeFrequency relativeFrequency = (RelativeFrequency)object;
                if (!Intrinsics.areEqual(this.valueRange, relativeFrequency.valueRange) || Double.compare(this.frequency, relativeFrequency.frequency) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

