/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.distribution;

import com.atlassian.performance.tools.report.Point;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/performance/tools/report/distribution/Quantile;", "Lcom/atlassian/performance/tools/report/Point;", "", "cumulativeProbability", "value", "(DD)V", "getCumulativeProbability", "()D", "getValue", "x", "getX", "()Ljava/lang/Double;", "y", "Ljava/math/BigDecimal;", "getY", "()Ljava/math/BigDecimal;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "labelX", "", "toString", "report"})
public final class Quantile
implements Point<Double> {
    private final double x;
    @NotNull
    private final BigDecimal y;
    private final double cumulativeProbability;
    private final double value;

    @Override
    @NotNull
    public Double getX() {
        return this.x;
    }

    @Override
    @NotNull
    public BigDecimal getY() {
        return this.y;
    }

    @Override
    @NotNull
    public String labelX() {
        double d = this.cumulativeProbability * (double)100;
        String string = new BigDecimal(String.valueOf(d)).setScale(0, RoundingMode.HALF_UP).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(cumulativeProbability *\u2026F_UP)\n        .toString()");
        return string;
    }

    public final double getCumulativeProbability() {
        return this.cumulativeProbability;
    }

    public final double getValue() {
        return this.value;
    }

    public Quantile(double cumulativeProbability, double value) {
        this.cumulativeProbability = cumulativeProbability;
        this.value = value;
        this.x = this.cumulativeProbability;
        double d = this.value;
        Quantile quantile = this;
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, RoundingMode.HALF_UP);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"value\n        .toBigDeci\u2026(0, RoundingMode.HALF_UP)");
        quantile.y = bigDecimal2;
    }

    public final double component1() {
        return this.cumulativeProbability;
    }

    public final double component2() {
        return this.value;
    }

    @NotNull
    public final Quantile copy(double cumulativeProbability, double value) {
        return new Quantile(cumulativeProbability, value);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Quantile copy$default(Quantile quantile, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = quantile.cumulativeProbability;
        }
        if ((n & 2) != 0) {
            d2 = quantile.value;
        }
        return quantile.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Quantile(cumulativeProbability=" + this.cumulativeProbability + ", value=" + this.value + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.cumulativeProbability);
        long l2 = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Quantile)) break block3;
                Quantile quantile = (Quantile)object;
                if (Double.compare(this.cumulativeProbability, quantile.cumulativeProbability) != 0 || Double.compare(this.value, quantile.value) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

