/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.distribution;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.report.JsonStyle;
import com.atlassian.performance.tools.report.Point;
import com.atlassian.performance.tools.report.api.result.EdibleResult;
import com.atlassian.performance.tools.report.chart.Chart;
import com.atlassian.performance.tools.report.chart.ChartLine;
import com.atlassian.performance.tools.report.distribution.DistributionComparison;
import com.atlassian.performance.tools.workspace.api.git.GitRepo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonStructure;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J!\u0010\u0013\u001a\u00020\t2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0014Ji\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0012\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u00172\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0018\u001a\u00020\u001023\u0010\u0015\u001a/\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001a0\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u001e0\u000b0\u0019H\u0002Ji\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160 0\u000b\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u00172\u0006\u0010!\u001a\u00020\f23\u0010\u0015\u001a/\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001a0\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u001e0\u000b0\u00192\u0006\u0010\u0018\u001a\u00020\u0010H\u0002Ji\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160 0\u000b\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u001723\u0010\u0015\u001a/\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001a0\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u001e0\u000b0\u00192\u0006\u0010!\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/performance/tools/report/distribution/DistributionComparison;", "", "repo", "Lcom/atlassian/performance/tools/workspace/api/git/GitRepo;", "(Lcom/atlassian/performance/tools/workspace/api/git/GitRepo;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "compare", "", "results", "", "Lcom/atlassian/performance/tools/report/api/result/EdibleResult;", "output", "Ljava/nio/file/Path;", "print", "", "chart", "Lcom/atlassian/performance/tools/report/chart/Chart;", "render", "render$report", "summarize", "T", "", "yAxisId", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "metrics", "Lcom/atlassian/performance/tools/report/Point;", "summarizeEachActionType", "Lcom/atlassian/performance/tools/report/chart/ChartLine;", "result", "summarizeEntireCohort", "report"})
public final class DistributionComparison {
    private final Logger logger;
    private final GitRepo repo;

    public final void compare(@NotNull List<EdibleResult> results, @NotNull Path output) {
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Chart quantileFunction2 = this.summarize(results, "latency-axis", compare.quantileFunction.1.INSTANCE);
        this.render$report(quantileFunction2, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render$report(@NotNull Chart<?> chart, @NotNull Path output) {
        Object object;
        Object it2;
        Intrinsics.checkParameterIsNotNull(chart, (String)"chart");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        InputStream inputStream = this.getClass().getResourceAsStream("distribution-comparison-template.html");
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"this::class\n            \u2026omparison-template.html\")");
        Object object2 = inputStream;
        Object object3 = Charsets.UTF_8;
        Closeable closeable = object2;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object3);
        int n = 8192;
        object2 = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        object3 = null;
        try {
            it2 = (BufferedReader)object2;
            it2 = TextStreamsKt.readText((Reader)((Reader)it2));
        }
        catch (Throwable it2) {
            object3 = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        String report = StringsKt.replace$default((String)StringsKt.replace$default((String)it2, (String)"'<%= quantileFunction =%>'", (String)this.print(chart), (boolean)false, (int)4, null), (String)"'<%= commit =%>'", (String)this.repo.getHead(), (boolean)false, (int)4, null);
        File file = output.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output.toFile()");
        object2 = DirectoriesKt.ensureParentDirectory((File)file);
        object3 = Charsets.UTF_8;
        Object $i$a$1$use = object2;
        n = 8192;
        Object object4 = object = $i$a$1$use;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        object2 = new PrintWriter(writer);
        object3 = null;
        try {
            it2 = (PrintWriter)object2;
            ((PrintWriter)it2).print(report);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        this.logger.info("Distribution comparison available at " + output.toUri());
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Comparable<? super T>> Chart<T> summarize(List<EdibleResult> results, String yAxisId, Function1<? super List<Integer>, ? extends List<? extends Point<T>>> summarize) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Chart chart;
        Iterable iterable = results;
        Chart chart2 = chart;
        Chart chart3 = chart;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            EdibleResult result = (EdibleResult)element$iv$iv;
            Iterable list$iv$iv = CollectionsKt.plus((Collection)this.summarizeEntireCohort(summarize, result, yAxisId), (Iterable)this.summarizeEachActionType(result, summarize, yAxisId));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        chart2(list);
        return chart3;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Comparable<? super T>> List<ChartLine<T>> summarizeEntireCohort(Function1<? super List<Integer>, ? extends List<? extends Point<T>>> summarize, EdibleResult result, String yAxisId) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        ChartLine chartLine;
        Iterable iterable = result.getActionMetrics();
        Function1<? super List<Integer>, ? extends List<? extends Point<T>>> function1 = summarize;
        ChartLine chartLine2 = chartLine;
        ChartLine chartLine3 = chartLine;
        String string = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ActionMetric actionMetric = (ActionMetric)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = (int)it.getDuration().toMillis();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        boolean bl = false;
        string = yAxisId;
        String string2 = "line";
        String string3 = result.getCohort();
        chartLine2((List)function1.invoke((Object)collection), result.getCohort(), string2, string, bl, string3);
        return CollectionsKt.listOf(chartLine3);
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Comparable<? super T>> List<ChartLine<T>> summarizeEachActionType(EdibleResult result, Function1<? super List<Integer>, ? extends List<? extends Point<T>>> summarize, String yAxisId) {
        Object it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = result.getActionMetrics();
        void var5_5 = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            it = (ActionMetric)element$iv$iv;
            String key$iv$iv = it.getLabel();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv.entrySet();
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new Comparator<T>(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        $receiver$iv = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Collection<Integer> collection;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            ChartLine chartLine;
            void $actionType_metrics;
            it = (Map.Entry)item$iv$iv;
            Object object = destination$iv$iv;
            Iterable $i$a$1$groupBy = $actionType_metrics;
            String actionType = (String)$i$a$1$groupBy.getKey();
            $i$a$1$groupBy = $actionType_metrics;
            List metrics = (List)$i$a$1$groupBy.getValue();
            $i$a$1$groupBy = metrics;
            Function1<? super List<Integer>, ? extends List<? extends Point<T>>> function1 = summarize;
            ChartLine chartLine2 = chartLine;
            ChartLine chartLine3 = chartLine;
            void $i$f$getOrPut = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                void it2;
                ActionMetric actionMetric = (ActionMetric)item$iv$iv2;
                collection = destination$iv$iv2;
                Integer n = (int)it2.getDuration().toMillis();
                collection.add(n);
            }
            collection = (List)destination$iv$iv2;
            boolean bl = true;
            String string = yAxisId;
            String string2 = "line";
            String string3 = result.getCohort();
            chartLine2((List)function1.invoke((Object)collection), result.getCohort() + ": " + actionType, string2, string, bl, string3);
            ChartLine chartLine4 = chartLine3;
            object.add(chartLine4);
        }
        return (List)destination$iv$iv;
    }

    private final String print(Chart<?> chart) {
        return new JsonStyle().prettyPrint((JsonStructure)chart.toJson());
    }

    public DistributionComparison(@NotNull GitRepo repo) {
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        this.repo = repo;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

