/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart.waterfall;

import com.atlassian.performance.tools.report.JsonStyle;
import java.text.DecimalFormat;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/report/chart/waterfall/Utils;", "", "()V", "prettyPrint", "", "json", "Ljavax/json/JsonObject;", "address", "toHumanReadableSize", "size", "", "report"})
public final class Utils {
    @NotNull
    public final String toHumanReadableSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    @NotNull
    public final String prettyPrint(@NotNull JsonObject json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        return new JsonStyle().prettyPrint((JsonStructure)json);
    }

    @NotNull
    public final String prettyPrint(@NotNull String address) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        String label = StringsKt.substringAfterLast$default((String)address, (char)'/', null, (int)2, null);
        int maxLength = 30;
        if (label.length() > maxLength) {
            String string2 = label;
            int n = 0;
            int n2 = maxLength - 3;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            string = stringBuilder.append(string5).append("...").toString();
        } else {
            string = label;
        }
        return string;
    }
}

