/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart;

import com.atlassian.performance.tools.infrastructure.api.metric.Dimension;
import com.atlassian.performance.tools.infrastructure.api.metric.SystemMetric;
import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.report.JsonStyle;
import com.atlassian.performance.tools.report.chart.ChartBuilder;
import com.atlassian.performance.tools.report.chart.SystemMetricsChart;
import com.atlassian.performance.tools.workspace.api.git.GitRepo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/report/chart/TimelineChart;", "", "repo", "Lcom/atlassian/performance/tools/workspace/api/git/GitRepo;", "(Lcom/atlassian/performance/tools/workspace/api/git/GitRepo;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "generate", "", "output", "Ljava/nio/file/Path;", "actionMetrics", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;", "systemMetrics", "Lcom/atlassian/performance/tools/infrastructure/api/metric/SystemMetric;", "systemMetricsCharts", "Ljavax/json/JsonArray;", "trimmedSystemMetrics", "trimSystemMetrics", "report"})
public final class TimelineChart {
    private final Logger logger;
    private final GitRepo repo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate(@NotNull Path output, @NotNull List<ActionMetric> actionMetrics, @NotNull List<SystemMetric> systemMetrics) {
        Object object;
        Object it2;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(actionMetrics, (String)"actionMetrics");
        Intrinsics.checkParameterIsNotNull(systemMetrics, (String)"systemMetrics");
        List<SystemMetric> trimmedSystemMetrics = this.trimSystemMetrics(actionMetrics, systemMetrics);
        InputStream inputStream = this.getClass().getResourceAsStream("timeline-chart-template.html");
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"this::class\n            \u2026ine-chart-template.html\")");
        Object object2 = inputStream;
        Object object3 = Charsets.UTF_8;
        Closeable closeable = object2;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object3);
        int n = 8192;
        object2 = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        object3 = null;
        try {
            it2 = (BufferedReader)object2;
            it2 = TextStreamsKt.readText((Reader)((Reader)it2));
        }
        catch (Throwable it2) {
            object3 = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        String report = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)it2, (String)"'<%= virtualUserChartData =%>'", (String)new JsonStyle().prettyPrint((JsonStructure)new ChartBuilder().build(actionMetrics).toJson()), (boolean)false, (int)4, null), (String)"'<%= systemMetricsCharts =%>'", (String)new JsonStyle().prettyPrint((JsonStructure)this.systemMetricsCharts(trimmedSystemMetrics)), (boolean)false, (int)4, null), (String)"'<%= commit =%>'", (String)this.repo.getHead(), (boolean)false, (int)4, null);
        File file = output.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output.toFile()");
        object2 = DirectoriesKt.ensureParentDirectory((File)file);
        object3 = Charsets.UTF_8;
        Object $i$a$1$use = object2;
        n = 8192;
        Object object4 = object = $i$a$1$use;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        object2 = new PrintWriter(writer);
        object3 = null;
        try {
            it2 = (PrintWriter)object2;
            ((PrintWriter)it2).print(report);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        this.logger.info("Timeline chart available at " + output.toUri());
    }

    private final JsonArray systemMetricsCharts(List<SystemMetric> trimmedSystemMetrics) {
        JsonArray jsonArray = Json.createArrayBuilder().add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.CPU_LOAD, "cpu-load-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_SURVI_0, "survi-0-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_SURVI_1, "survi-1-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_EDEN, "eden-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_OLD, "old-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_COMPRESSED_CLASS, "meta-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_YOUNG_GEN_GC, "young-gc-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_YOUNG_GEN_GC_TIME, "young-gc-time-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_FULL_GC, "full-gc-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_FULL_GC_TIME, "full-gc-time-axis").toJson()).add((JsonValue)new SystemMetricsChart(trimmedSystemMetrics, Dimension.JSTAT_TOTAL_GC_TIME, "total-gc-time-axis").toJson()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"Json\n            .create\u2026n())\n            .build()");
        return jsonArray;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SystemMetric> trimSystemMetrics(List<ActionMetric> actionMetrics, List<SystemMetric> systemMetrics) {
        SystemMetric it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        void $receiver$iv2;
        if (actionMetrics.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = actionMetrics;
        void var5_4 = $receiver$iv2;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                ActionMetric it = (ActionMetric)a;
                Comparable comparable = it.getStart();
                it = (ActionMetric)b;
                Comparable comparable2 = comparable;
                Instant instant = it.getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)instant);
            }
        };
        List metricsSortedByTime = CollectionsKt.sortedWith((Iterable)var5_4, (Comparator)object);
        Instant beginning = ((ActionMetric)CollectionsKt.first((List)metricsSortedByTime)).getStart();
        Instant end = ((ActionMetric)CollectionsKt.last((List)metricsSortedByTime)).getStart();
        object = systemMetrics;
        void $i$f$sortedBy = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (SystemMetric)element$iv$iv;
            if (!it.getStart().isAfter(beginning)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (SystemMetric)element$iv$iv;
            if (!it.getStart().isBefore(end)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public TimelineChart(@NotNull GitRepo repo) {
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        this.repo = repo;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

