/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart;

import com.atlassian.performance.tools.infrastructure.api.metric.Dimension;
import com.atlassian.performance.tools.infrastructure.api.metric.SystemMetric;
import com.atlassian.performance.tools.report.JsonProviderSingleton;
import com.atlassian.performance.tools.report.chart.Chart;
import com.atlassian.performance.tools.report.chart.ChartAxis;
import com.atlassian.performance.tools.report.chart.ChartLine;
import com.atlassian.performance.tools.report.chart.Tick;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB+\u0012\u0006\u0010\n\u001a\u00020\b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0012\u001a\u00020\bH\u0002J\"\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015JR\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/performance/tools/report/chart/SystemMetricsChart;", "", "allMetrics", "", "Lcom/atlassian/performance/tools/infrastructure/api/metric/SystemMetric;", "dimension", "Lcom/atlassian/performance/tools/infrastructure/api/metric/Dimension;", "axisId", "", "(Ljava/util/List;Lcom/atlassian/performance/tools/infrastructure/api/metric/Dimension;Ljava/lang/String;)V", "title", "axis", "Lcom/atlassian/performance/tools/report/chart/ChartAxis;", "(Ljava/lang/String;Ljava/util/List;Lcom/atlassian/performance/tools/infrastructure/api/metric/Dimension;Lcom/atlassian/performance/tools/report/chart/ChartAxis;)V", "getReducedValue", "Lcom/atlassian/performance/tools/report/chart/ChartLine;", "Ljava/time/Instant;", "metrics", "label", "plotValuesPerSystem", "toJson", "Ljavax/json/JsonObject;", "toChartLine", "yAxisId", "type", "hidden", "", "reduce", "Lkotlin/Function1;", "", "report"})
public final class SystemMetricsChart {
    private final String title;
    private final List<SystemMetric> allMetrics;
    private final Dimension dimension;
    private final ChartAxis axis;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonObject toJson() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.allMetrics;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SystemMetric it = (SystemMetric)element$iv$iv;
            if (!(it.getDimension() == this.dimension)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                SystemMetric it = (SystemMetric)a;
                Comparable comparable = it.getStart();
                it = (SystemMetric)b;
                Comparable comparable2 = comparable;
                Instant instant = it.getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)instant);
            }
        };
        List metrics = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        Chart chartData = new Chart(this.plotValuesPerSystem(metrics));
        JsonObject jsonObject = JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder().add("title", this.title).add("axis", (JsonValue)this.axis.toJson()).add("data", (JsonValue)chartData.toJson()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"JSON.createObjectBuilder\u2026n())\n            .build()");
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ChartLine<Instant>> plotValuesPerSystem(List<SystemMetric> metrics) {
        Object object;
        String it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = metrics;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            SystemMetric systemMetric = (SystemMetric)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getSystem();
            collection.add(object);
        }
        $receiver$iv = CollectionsKt.sorted((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void system;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            Iterable $i$a$1$map = metrics;
            SystemMetricsChart systemMetricsChart = this;
            void $i$f$map = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                SystemMetric it2 = (SystemMetric)element$iv$iv;
                if (!Intrinsics.areEqual((Object)it2.getSystem(), (Object)system)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            object = systemMetricsChart.getReducedValue(list, (String)system);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    private final ChartLine<Instant> getReducedValue(List<SystemMetric> metrics, String label) {
        Function1 function1 = (Function1)new Function1<List<? extends SystemMetric>, Double>(this){
            final /* synthetic */ SystemMetricsChart this$0;

            /*
             * WARNING - void declaration
             */
            public final double invoke(@NotNull List<SystemMetric> it) {
                Collection<Double> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                Iterable iterable = it;
                Function1 function1 = SystemMetricsChart.access$getDimension$p(this.this$0).getReduction().getLambda();
                void var3_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it2;
                    SystemMetric systemMetric = (SystemMetric)item$iv$iv;
                    collection = destination$iv$iv;
                    Double d = it2.getValue();
                    collection.add(d);
                }
                collection = (List)destination$iv$iv;
                return ((Number)function1.invoke((Object)collection)).doubleValue();
            }
            {
                this.this$0 = systemMetricsChart;
                super(1);
            }
        };
        boolean bl = false;
        String string = this.axis.getId();
        String string2 = "line";
        return this.toChartLine(metrics, label, string, string2, bl, (Function1<? super List<SystemMetric>, Double>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final ChartLine<Instant> toChartLine(@NotNull List<SystemMetric> $receiver, String label, String yAxisId, String type, boolean hidden, Function1<? super List<SystemMetric>, Double> reduce) {
        Object object;
        Object object2;
        Map.Entry it$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $receiver$iv$iv$iv;
        Map $receiver$iv$iv;
        Map $receiver$iv;
        Sequence sequence = CollectionsKt.asSequence((Iterable)$receiver);
        void var9_8 = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Object object3 = $receiver$iv$iv.iterator();
        while (object3.hasNext()) {
            Object object4;
            $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object3.next();
            SystemMetric it = (SystemMetric)element$iv$iv;
            key$iv$iv = it.getStart().truncatedTo(ChronoUnit.MINUTES);
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv2 = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv2) {
            void entry;
            Map.Entry $i$a$1$groupBy = (Map.Entry)element$iv$iv$iv;
            key$iv$iv = destination$iv$iv;
            $receiver$iv$iv$iv = it$iv$iv.getKey();
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            object2 = $receiver$iv$iv$iv;
            object = key$iv$iv;
            Double d = ((Number)reduce.invoke(entry.getValue())).doubleValue();
            object.put(object2, d);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.size());
        object3 = $receiver$iv$iv;
        Object object5 = object3.entrySet().iterator();
        while (object5.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            it$iv$iv = item$iv$iv = (Map.Entry)object5.next();
            object = destination$iv$iv;
            Object k = it.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
            object2 = new Tick((Instant)k, ((Number)it.getValue()).doubleValue());
            object.add(object2);
        }
        List data = (List)destination$iv$iv;
        sequence = null;
        boolean bl = hidden;
        List list = data;
        object3 = yAxisId;
        object5 = type;
        String string = label;
        return new ChartLine<Instant>(list, string, (String)object5, (String)object3, bl, (String)sequence, 32, null);
    }

    public SystemMetricsChart(@NotNull String title, @NotNull List<SystemMetric> allMetrics, @NotNull Dimension dimension, @NotNull ChartAxis axis) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(allMetrics, (String)"allMetrics");
        Intrinsics.checkParameterIsNotNull((Object)dimension, (String)"dimension");
        Intrinsics.checkParameterIsNotNull((Object)axis, (String)"axis");
        this.title = title;
        this.allMetrics = allMetrics;
        this.dimension = dimension;
        this.axis = axis;
    }

    public SystemMetricsChart(@NotNull List<SystemMetric> allMetrics, @NotNull Dimension dimension, @NotNull String axisId) {
        Intrinsics.checkParameterIsNotNull(allMetrics, (String)"allMetrics");
        Intrinsics.checkParameterIsNotNull((Object)dimension, (String)"dimension");
        Intrinsics.checkParameterIsNotNull((Object)axisId, (String)"axisId");
        this(dimension.getDescription(), allMetrics, dimension, new ChartAxis(axisId, dimension.getDescription()));
    }

    @NotNull
    public static final /* synthetic */ Dimension access$getDimension$p(SystemMetricsChart $this) {
        return $this.dimension;
    }
}

