/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.report.JsonProviderSingleton;
import com.atlassian.performance.tools.report.JsonStyle;
import com.atlassian.performance.tools.report.MeanAggregator;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.chart.CohortMeanLatency;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J*\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/performance/tools/report/chart/MeanLatencyChart;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getColor", "Ljavax/json/JsonArray;", "dataSize", "", "opacity", "", "getDataset", "Ljavax/json/JsonObject;", "latencies", "", "Lcom/atlassian/performance/tools/report/chart/CohortMeanLatency;", "plot", "", "stats", "", "Lcom/atlassian/performance/tools/report/api/result/Stats;", "labels", "", "output", "Ljava/io/File;", "prettyPrint", "json", "cohort", "toJson", "report"})
public final class MeanLatencyChart {
    private final Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void plot(@NotNull Collection<? extends Stats> stats2, @NotNull List<String> labels, @NotNull File output) {
        Object object;
        Object it3;
        Object item$iv$iv2;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(stats2, (String)"stats");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Iterable $receiver$iv = stats2;
        Object object2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv) {
            void it2;
            Stats stats3 = (Stats)item$iv$iv2;
            Collection collection = destination$iv$iv;
            CohortMeanLatency cohortMeanLatency = new CohortMeanLatency(it2.getCohort(), new MeanAggregator().aggregateCenters(labels, (Stats)it2));
            collection.add(cohortMeanLatency);
        }
        List latencies = (List)destination$iv$iv;
        InputStream inputStream = this.getClass().getResourceAsStream("aggregate-chart-template.html");
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"this::class\n            \u2026ate-chart-template.html\")");
        object2 = inputStream;
        Object object3 = Charsets.UTF_8;
        item$iv$iv2 = object2;
        item$iv$iv2 = new InputStreamReader((InputStream)item$iv$iv2, (Charset)object3);
        int n = 8192;
        object2 = item$iv$iv2 instanceof BufferedReader ? (BufferedReader)item$iv$iv2 : new BufferedReader((Reader)item$iv$iv2, n);
        object3 = null;
        try {
            it3 = (BufferedReader)object2;
            it3 = TextStreamsKt.readText((Reader)((Reader)it3));
        }
        catch (Throwable it3) {
            object3 = it3;
            throw it3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        String report = StringsKt.replace$default((String)it3, (String)"'<%= aggregateChartData =%>'", (String)this.prettyPrint(this.toJson(latencies)), (boolean)false, (int)4, null);
        object2 = DirectoriesKt.ensureParentDirectory((File)output);
        object3 = Charsets.UTF_8;
        Object $i$a$1$use = object2;
        n = 8192;
        Object object4 = object = $i$a$1$use;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        object2 = new PrintWriter(writer);
        object3 = null;
        try {
            it3 = (PrintWriter)object2;
            ((PrintWriter)it3).print(report);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        this.logger.info("Mean latency chart is available at " + output.toURI());
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject toJson(List<CohortMeanLatency> latencies) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = latencies;
        JsonProvider jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        String string = "labels";
        JsonObjectBuilder jsonObjectBuilder = JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder();
        void var3_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CohortMeanLatency cohortMeanLatency = (CohortMeanLatency)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = this.prettyPrint(it.getCohort());
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        JsonObject jsonObject = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder((Collection)collection).build()).add("datasets", (JsonValue)JsonProviderSingleton.INSTANCE.getJSON().createArrayBuilder().add((JsonValue)this.getDataset(latencies)).build()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"JSON.createObjectBuilder\u2026build())\n        .build()");
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject getDataset(List<CohortMeanLatency> latencies) {
        Collection<Long> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = latencies;
        JsonProvider jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        String string = "data";
        JsonObjectBuilder jsonObjectBuilder = JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder().add("label", "Latency experienced by virtual users");
        void var3_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CohortMeanLatency cohortMeanLatency = (CohortMeanLatency)item$iv$iv;
            collection = destination$iv$iv;
            Long l = it.getMeanLatency();
            collection.add(l);
        }
        collection = (List)destination$iv$iv;
        JsonObject jsonObject = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder((Collection)collection).build()).add("backgroundColor", (JsonValue)this.getColor(latencies.size(), 0.2)).add("borderColor", (JsonValue)this.getColor(latencies.size(), 1.0)).add("borderWidth", 1).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"JSON.createObjectBuilder\u2026dth\", 1)\n        .build()");
        return jsonObject;
    }

    private final JsonArray getColor(int dataSize, double opacity) {
        String normalEntry = "rgba(54, 162, 235, " + opacity + ')';
        String lastEntry = "rgba(75, 192, 192, " + opacity + ')';
        JsonArrayBuilder colorBuilder = JsonProviderSingleton.INSTANCE.getJSON().createArrayBuilder();
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)1, (int)dataSize);
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            colorBuilder.add(normalEntry);
        }
        colorBuilder.add(lastEntry);
        JsonArray jsonArray = colorBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"colorBuilder.build()");
        return jsonArray;
    }

    private final String prettyPrint(JsonObject json) {
        return new JsonStyle().prettyPrint((JsonStructure)json);
    }

    private final String prettyPrint(String cohort) {
        String string;
        try {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendPattern("'T'HH-mm-ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 3, true).toFormatter();
            String string2 = LocalDateTime.parse(cohort, formatter).format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"LocalDateTime\n          \u2026eTime(FormatStyle.SHORT))");
            string = string2;
        }
        catch (Exception e) {
            string = cohort;
        }
        return string;
    }
}

