/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.result;

import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.jiraactions.api.ActionMetricStatistics;
import com.atlassian.performance.tools.report.api.OutlierTrimming;
import com.atlassian.performance.tools.report.api.result.DurationData;
import com.atlassian.performance.tools.report.api.result.EdibleResult;
import com.atlassian.performance.tools.report.api.result.InteractionStats;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.result.InternalStatsMeter;
import com.atlassian.performance.tools.report.result.PerformanceStats;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.jetbrains.annotations.NotNull;

@kotlin.Deprecated(message="This class will no longer be part of API. If you need Stats meter results go to EdibleResult class")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/performance/tools/report/api/result/StatsMeter;", "", "()V", "calculate", "", "", "Ljava/time/Duration;", "metrics", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;", "metric", "Lorg/apache/commons/math3/stat/descriptive/UnivariateStatistic;", "outlierTrimming", "Lcom/atlassian/performance/tools/report/api/OutlierTrimming;", "measure", "data", "Lcom/atlassian/performance/tools/report/api/result/DurationData;", "Lcom/atlassian/performance/tools/report/api/result/InteractionStats;", "result", "Lcom/atlassian/performance/tools/report/api/result/EdibleResult;", "centralTendencyMetric", "dispersionMetric", "measurePerformance", "Lcom/atlassian/performance/tools/report/api/result/Stats;", "Companion", "report"})
public final class StatsMeter {
    private static final InternalStatsMeter internalStatsMeter;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final Stats measurePerformance(@NotNull EdibleResult result, @NotNull UnivariateStatistic centralTendencyMetric, @NotNull UnivariateStatistic dispersionMetric, @NotNull OutlierTrimming outlierTrimming) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)centralTendencyMetric, (String)"centralTendencyMetric");
        Intrinsics.checkParameterIsNotNull((Object)dispersionMetric, (String)"dispersionMetric");
        Intrinsics.checkParameterIsNotNull((Object)outlierTrimming, (String)"outlierTrimming");
        if (result.getFailure() != null) {
            return new PerformanceStats(result.getCohort(), MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap());
        }
        List<ActionMetric> metrics = result.getActionMetrics();
        ActionMetricStatistics statistics = new ActionMetricStatistics(metrics);
        Map<String, Duration> centers = this.calculate(metrics, centralTendencyMetric, outlierTrimming);
        Map<String, Duration> dispersions = this.calculate(metrics, dispersionMetric, outlierTrimming);
        Map sampleSizes = new LinkedHashMap();
        Map errors = new LinkedHashMap();
        for (String label : result.getActionLabels()) {
            Map map2 = sampleSizes;
            Number number = ((Number)statistics.getSampleSize().getOrDefault(label, 0)).intValue();
            map2.put(label, number);
            map2 = errors;
            number = statistics.getErrors().getOrDefault(label, 0);
            map2.put(label, number);
        }
        return new PerformanceStats(result.getCohort(), sampleSizes, centers, dispersions, errors);
    }

    @NotNull
    public final InteractionStats measure(@NotNull EdibleResult result, @NotNull UnivariateStatistic centralTendencyMetric, @NotNull UnivariateStatistic dispersionMetric, @NotNull OutlierTrimming outlierTrimming) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)centralTendencyMetric, (String)"centralTendencyMetric");
        Intrinsics.checkParameterIsNotNull((Object)dispersionMetric, (String)"dispersionMetric");
        Intrinsics.checkParameterIsNotNull((Object)outlierTrimming, (String)"outlierTrimming");
        if (result.getFailure() != null) {
            return new InteractionStats(result.getCohort(), null, null, null, null);
        }
        List<ActionMetric> metrics = result.getActionMetrics();
        ActionMetricStatistics statistics = new ActionMetricStatistics(metrics);
        Map<String, Duration> centers = this.calculate(metrics, centralTendencyMetric, outlierTrimming);
        Map<String, Duration> dispersions = this.calculate(metrics, dispersionMetric, outlierTrimming);
        Map sampleSizes = new LinkedHashMap();
        Map errors = new LinkedHashMap();
        for (String label : result.getActionLabels()) {
            Map map2 = sampleSizes;
            Number number = ((Number)statistics.getSampleSize().getOrDefault(label, 0)).intValue();
            map2.put(label, number);
            map2 = errors;
            number = statistics.getErrors().getOrDefault(label, 0);
            map2.put(label, number);
        }
        return new InteractionStats(result.getCohort(), sampleSizes, centers, dispersions, errors);
    }

    @NotNull
    public final Map<String, Duration> calculate(@NotNull List<ActionMetric> metrics, @NotNull UnivariateStatistic metric, @NotNull OutlierTrimming outlierTrimming) {
        Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        Intrinsics.checkParameterIsNotNull((Object)outlierTrimming, (String)"outlierTrimming");
        return internalStatsMeter.calculate$report(metrics, metric, outlierTrimming);
    }

    @NotNull
    public final Duration measure(@NotNull DurationData data, @NotNull UnivariateStatistic metric, @NotNull OutlierTrimming outlierTrimming) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        Intrinsics.checkParameterIsNotNull((Object)outlierTrimming, (String)"outlierTrimming");
        double measurement = outlierTrimming.measureWithoutOutliers(data.getStats(), metric);
        return (Duration)data.getDurationMapping$report().invoke((Object)measurement);
    }

    static {
        Companion = new Companion(null);
        internalStatsMeter = new InternalStatsMeter();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/performance/tools/report/api/result/StatsMeter$Companion;", "", "()V", "internalStatsMeter", "Lcom/atlassian/performance/tools/report/result/InternalStatsMeter;", "report"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

