/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.junit;

import com.atlassian.performance.tools.report.api.junit.JUnitReport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/report/api/junit/ExceptionJUnitReport;", "Lcom/atlassian/performance/tools/report/api/junit/JUnitReport;", "testName", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "successful", "", "getSuccessful", "()Z", "getTestName", "()Ljava/lang/String;", "toString", "toXml", "testClassName", "report"})
public final class ExceptionJUnitReport
implements JUnitReport {
    private final boolean successful = false;
    @NotNull
    private final String testName;
    private final Exception exception;

    @Override
    public boolean getSuccessful() {
        return this.successful;
    }

    @Override
    @NotNull
    public String toXml(@NotNull String testClassName) {
        Intrinsics.checkParameterIsNotNull((Object)testClassName, (String)"testClassName");
        StringWriter stackTrace = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stackTrace));
        String exceptionMarker = "EXCEPTION_MARKER";
        String string = StringsKt.trimIndent((String)("\n            <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <testsuite name=\"" + testClassName + "\" tests=\"1\" skipped=\"0\" failures=\"1\" errors=\"0\">\n            <testcase name=\"" + this.getTestName() + "\" classname=\"" + testClassName + "\">\n                <failure message=\"" + this.exception.getMessage() + "\" type=\"" + this.exception.getClass().getName() + "\">" + exceptionMarker + "</failure>\n            </testcase>\n            </testsuite>\n        "));
        String string2 = stackTrace.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stackTrace.toString()");
        return StringsKt.replace$default((String)string, (String)exceptionMarker, (String)string2, (boolean)false, (int)4, null);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.exception.getClass().getName()).append(": ");
        String string = this.exception.getMessage();
        if (string == null) {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    @Override
    @NotNull
    public String getTestName() {
        return this.testName;
    }

    public ExceptionJUnitReport(@NotNull String testName, @NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        this.testName = testName;
        this.exception = exception;
    }

    @Override
    public void dump(@NotNull String testClassName, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)testClassName, (String)"testClassName");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        JUnitReport.DefaultImpls.dump(this, testClassName, path);
    }
}

