/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.judge;

import com.atlassian.performance.tools.report.api.PerformanceCriteria;
import com.atlassian.performance.tools.report.api.judge.Verdict;
import com.atlassian.performance.tools.report.api.junit.FailedAssertionJUnitReport;
import com.atlassian.performance.tools.report.api.junit.JUnitReport;
import com.atlassian.performance.tools.report.api.junit.SuccessfulJUnitReport;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/VirtualUsersJudge;", "", "criteria", "Lcom/atlassian/performance/tools/report/api/PerformanceCriteria;", "(Lcom/atlassian/performance/tools/report/api/PerformanceCriteria;)V", "judge", "Lcom/atlassian/performance/tools/report/api/judge/Verdict;", "nodeCounts", "", "", "", "cohort", "testMethodName", "report"})
public final class VirtualUsersJudge {
    private final PerformanceCriteria criteria;

    @NotNull
    public final Verdict judge(@NotNull Map<String, Integer> nodeCounts, @NotNull String cohort) {
        Intrinsics.checkParameterIsNotNull(nodeCounts, (String)"nodeCounts");
        Intrinsics.checkParameterIsNotNull((Object)cohort, (String)"cohort");
        int expected = this.criteria.getVirtualUserLoad().getVirtualUsers();
        int active = CollectionsKt.sumOfInt((Iterable)nodeCounts.values());
        JUnitReport report = expected - active <= this.criteria.getMaxInactiveVirtualUsers() ? (JUnitReport)new SuccessfulJUnitReport(this.testMethodName(cohort)) : (JUnitReport)new FailedAssertionJUnitReport(this.testMethodName(cohort), expected + " virtual users were expected, but only " + active + ' ' + "logged in to the JIRA. It's below maxInactiveVirtualUsers criteria (" + this.criteria.getMaxInactiveVirtualUsers() + ')');
        return new Verdict.Builder().addReport(report).build();
    }

    private final String testMethodName(String cohort) {
        return "Active_virtual_users_count_for_" + cohort;
    }

    public VirtualUsersJudge(@NotNull PerformanceCriteria criteria) {
        Intrinsics.checkParameterIsNotNull((Object)criteria, (String)"criteria");
        this.criteria = criteria;
    }
}

