/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.judge;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.api.junit.FailedAssertionJUnitReport;
import com.atlassian.performance.tools.report.api.junit.JUnitReport;
import com.atlassian.performance.tools.report.api.junit.SuccessfulJUnitReport;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001 B\u0015\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B'\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0003\u00a2\u0006\u0002\u0010\bJ'\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0000H\u0086\u0002R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006!"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/Verdict;", "", "reports", "", "Lcom/atlassian/performance/tools/report/api/junit/JUnitReport;", "(Ljava/util/List;)V", "failedActions", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "(Ljava/util/List;Ljava/util/List;)V", "getFailedActions", "()Ljava/util/List;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "positive", "", "getPositive", "()Z", "getReports", "assertAccepted", "", "testClassName", "", "testResults", "Ljava/nio/file/Path;", "expectedReportCount", "", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/Integer;)V", "checkIfNoReportIsMissing", "(Ljava/lang/Integer;)Lcom/atlassian/performance/tools/report/api/junit/JUnitReport;", "plus", "other", "Builder", "report"})
public final class Verdict {
    private final Logger logger;
    private final boolean positive;
    @NotNull
    private final List<JUnitReport> reports;
    @NotNull
    private final List<ActionType<?>> failedActions;

    public final boolean getPositive() {
        return this.positive;
    }

    /*
     * WARNING - void declaration
     */
    public final void assertAccepted(@NotNull String testClassName, @NotNull Path testResults, @Nullable Integer expectedReportCount) {
        void $receiver$iv$iv;
        Object element$iv2;
        Intrinsics.checkParameterIsNotNull((Object)testClassName, (String)"testClassName");
        Intrinsics.checkParameterIsNotNull((Object)testResults, (String)"testResults");
        List allReports = CollectionsKt.plus((Collection)this.reports, (Object)this.checkIfNoReportIsMissing(expectedReportCount));
        Iterable $receiver$iv = allReports;
        for (Object element$iv2 : $receiver$iv) {
            JUnitReport it = (JUnitReport)element$iv2;
            Path path = testResults.resolve("dynamic-" + testClassName);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"testResults.resolve(\"dynamic-$testClassName\")");
            it.dump(testClassName, path);
        }
        Iterable $receiver$iv2 = allReports;
        element$iv2 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JUnitReport it = (JUnitReport)element$iv$iv;
            if (!(!it.getSuccessful())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fails = (List)destination$iv$iv;
        Collection collection = fails;
        if (!collection.isEmpty()) {
            throw (Throwable)new Exception("Performance results are rejected, because:\n" + CollectionsKt.joinToString$default((Iterable)fails, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        this.logger.info("Performance results are accepted");
    }

    public static /* bridge */ /* synthetic */ void assertAccepted$default(Verdict verdict, String string, Path path, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        verdict.assertAccepted(string, path, n);
    }

    @NotNull
    public final Verdict plus(@NotNull Verdict other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Builder().addReports(this.reports).addReports(other.reports).build();
    }

    private final JUnitReport checkIfNoReportIsMissing(Integer expectedReportCount) {
        JUnitReport jUnitReport;
        String testName = "Report meta-check";
        if (expectedReportCount == null) {
            jUnitReport = new SuccessfulJUnitReport(testName);
        } else {
            int n = this.reports.size();
            if (expectedReportCount != n) {
                String string = testName;
                String string2 = expectedReportCount + " reports were expected, but " + this.reports.size() + " reports were yielded";
                jUnitReport = new FailedAssertionJUnitReport(string, string2);
            } else {
                jUnitReport = new SuccessfulJUnitReport(testName);
            }
        }
        return jUnitReport;
    }

    @NotNull
    public final List<JUnitReport> getReports() {
        return this.reports;
    }

    @NotNull
    public final List<ActionType<?>> getFailedActions() {
        return this.failedActions;
    }

    /*
     * WARNING - void declaration
     */
    public Verdict(@NotNull List<? extends JUnitReport> reports, @NotNull List<? extends ActionType<?>> failedActions) {
        boolean bl;
        boolean bl2;
        block3: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(reports, (String)"reports");
            Intrinsics.checkParameterIsNotNull(failedActions, (String)"failedActions");
            this.reports = reports;
            this.failedActions = failedActions;
            this.logger = LogManager.getLogger(this.getClass());
            Iterable iterable = this.reports;
            Verdict verdict = this;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    JUnitReport it = (JUnitReport)element$iv;
                    if (it.getSuccessful()) continue;
                    bl2 = false;
                    break block3;
                }
                bl2 = true;
            }
        }
        verdict.positive = bl = bl2;
    }

    @Deprecated(message="Use Builder instead", replaceWith=@ReplaceWith(imports={}, expression="Verdict.Builder().addReports(reports).build()"))
    public Verdict(@NotNull List<? extends JUnitReport> reports) {
        Intrinsics.checkParameterIsNotNull(reports, (String)"reports");
        this(reports, CollectionsKt.emptyList());
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\u00002\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0018\u0010\n\u001a\u00020\u00002\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0007J\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/Verdict$Builder;", "", "()V", "failedActions", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "reports", "Lcom/atlassian/performance/tools/report/api/junit/JUnitReport;", "addFailedAction", "failedAction", "addFailedActions", "", "addReport", "report", "addReports", "build", "Lcom/atlassian/performance/tools/report/api/judge/Verdict;"})
    public static final class Builder {
        private List<JUnitReport> reports = new ArrayList();
        private List<ActionType<?>> failedActions = new ArrayList();

        @NotNull
        public final Builder addReport(@NotNull JUnitReport report) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)report, (String)"report");
            Builder $receiver = builder = this;
            $receiver.reports.add(report);
            return builder;
        }

        @NotNull
        public final Builder addReports(@NotNull List<? extends JUnitReport> reports) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(reports, (String)"reports");
            Builder $receiver = builder = this;
            $receiver.reports.addAll((Collection<JUnitReport>)reports);
            return builder;
        }

        @NotNull
        public final Builder addFailedAction(@NotNull ActionType<?> failedAction) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(failedAction, (String)"failedAction");
            Builder $receiver = builder = this;
            $receiver.failedActions.add(failedAction);
            return builder;
        }

        @NotNull
        public final Builder addFailedActions(@NotNull List<? extends ActionType<?>> failedActions) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(failedActions, (String)"failedActions");
            Builder $receiver = builder = this;
            $receiver.failedActions.addAll((Collection)failedActions);
            return builder;
        }

        @NotNull
        public final Verdict build() {
            List<JUnitReport> list = Collections.unmodifiableList(this.reports);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(reports)");
            List<ActionType<?>> list2 = Collections.unmodifiableList(this.failedActions);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.unmodifiableList(failedActions)");
            return new Verdict(list, list2);
        }
    }
}

