/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.judge;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.api.judge.Verdict;
import com.atlassian.performance.tools.report.api.junit.FailedAssertionJUnitReport;
import com.atlassian.performance.tools.report.api.junit.JUnitReport;
import com.atlassian.performance.tools.report.api.junit.SuccessfulJUnitReport;
import com.atlassian.performance.tools.report.api.result.InteractionStats;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.result.PerformanceStats;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J5\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0011J5\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/RelativePerformanceStabilityJudge;", "", "()V", "dispersions", "Ljava/time/Duration;", "stats", "Lcom/atlassian/performance/tools/report/api/result/Stats;", "label", "", "judge", "Lcom/atlassian/performance/tools/report/api/judge/Verdict;", "maxDispersionDifferences", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "baselineStats", "Lcom/atlassian/performance/tools/report/api/result/InteractionStats;", "experimentStats", "judge$report", "report"})
public final class RelativePerformanceStabilityJudge {
    @Deprecated(message="Use the other judge method")
    @NotNull
    public final Verdict judge$report(@NotNull Map<ActionType<?>, Duration> maxDispersionDifferences, @NotNull InteractionStats baselineStats, @NotNull InteractionStats experimentStats) {
        Intrinsics.checkParameterIsNotNull(maxDispersionDifferences, (String)"maxDispersionDifferences");
        Intrinsics.checkParameterIsNotNull((Object)baselineStats, (String)"baselineStats");
        Intrinsics.checkParameterIsNotNull((Object)experimentStats, (String)"experimentStats");
        return this.judge$report(maxDispersionDifferences, PerformanceStats.Adapter.adapt(baselineStats), PerformanceStats.Adapter.adapt(experimentStats));
    }

    @NotNull
    public final Verdict judge$report(@NotNull Map<ActionType<?>, Duration> maxDispersionDifferences, @NotNull Stats baselineStats, @NotNull Stats experimentStats) {
        Map<ActionType<?>, Duration> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(maxDispersionDifferences, (String)"maxDispersionDifferences");
        Intrinsics.checkParameterIsNotNull((Object)baselineStats, (String)"baselineStats");
        Intrinsics.checkParameterIsNotNull((Object)experimentStats, (String)"experimentStats");
        Verdict.Builder verdict = new Verdict.Builder();
        Map<ActionType<?>, Duration> map2 = $receiver$iv = maxDispersionDifferences;
        Iterator<Map.Entry<ActionType<?>, Duration>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            JUnitReport jUnitReport;
            Map.Entry<ActionType<?>, Duration> element$iv;
            Map.Entry<ActionType<?>, Duration> $action_maxDispersionDifference;
            Map.Entry<ActionType<?>, Duration> entry = $action_maxDispersionDifference = (element$iv = iterator.next());
            ActionType<?> action = entry.getKey();
            entry = $action_maxDispersionDifference;
            Duration maxDispersionDifference = entry.getValue();
            String label = action.getLabel();
            Duration experimentDispersion = this.dispersions(experimentStats, label);
            Duration baselineDispersion = this.dispersions(baselineStats, label);
            Duration regression = experimentDispersion.minus(baselineDispersion);
            String reportName = "Stability regression for " + label + ' ' + experimentStats.getCohort() + " vs " + baselineStats.getCohort();
            if (regression.compareTo(maxDispersionDifference) > 0) {
                String message = label + ' ' + regression + " stability regression overcame " + maxDispersionDifference + " threshold";
                jUnitReport = new FailedAssertionJUnitReport(reportName, message);
            } else {
                jUnitReport = new SuccessfulJUnitReport(reportName);
            }
            JUnitReport report = jUnitReport;
            verdict.addReport(report);
        }
        return verdict.build();
    }

    private final Duration dispersions(Stats stats2, String label) {
        Duration duration = stats2.getDispersions().get(label);
        if (duration == null) {
            String string = "No action " + label + " for the cohort " + stats2.getCohort();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return duration;
    }
}

