/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.judge;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.api.ErrorCriteria;
import com.atlassian.performance.tools.report.api.judge.Verdict;
import com.atlassian.performance.tools.report.api.junit.FailedAssertionJUnitReport;
import com.atlassian.performance.tools.report.api.junit.SuccessfulJUnitReport;
import com.atlassian.performance.tools.report.api.result.InteractionStats;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.result.PerformanceStats;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\bH\u0007J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\bJ\u001c\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/ErrorsJudge;", "", "()V", "judge", "Lcom/atlassian/performance/tools/report/api/judge/Verdict;", "stats", "Lcom/atlassian/performance/tools/report/api/result/InteractionStats;", "criteria", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "Lcom/atlassian/performance/tools/report/api/ErrorCriteria;", "Lcom/atlassian/performance/tools/report/api/result/Stats;", "testMethodName", "", "action", "cohort", "report"})
public final class ErrorsJudge {
    @Deprecated(message="Use the other judge method.")
    @NotNull
    public final Verdict judge(@NotNull InteractionStats stats2, @NotNull Map<ActionType<?>, ErrorCriteria> criteria) {
        Intrinsics.checkParameterIsNotNull((Object)stats2, (String)"stats");
        Intrinsics.checkParameterIsNotNull(criteria, (String)"criteria");
        return this.judge(PerformanceStats.Adapter.adapt(stats2), criteria);
    }

    @NotNull
    public final Verdict judge(@NotNull Stats stats2, @NotNull Map<ActionType<?>, ErrorCriteria> criteria) {
        Intrinsics.checkParameterIsNotNull((Object)stats2, (String)"stats");
        Intrinsics.checkParameterIsNotNull(criteria, (String)"criteria");
        Verdict.Builder verdict = new Verdict.Builder();
        Map<ActionType<?>, ErrorCriteria> map2 = criteria;
        Iterator<Map.Entry<ActionType<?>, ErrorCriteria>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            int errorCount;
            Map.Entry<ActionType<?>, ErrorCriteria> entry;
            Map.Entry<ActionType<?>, ErrorCriteria> entry2 = entry = iterator.next();
            ActionType<?> action = entry2.getKey();
            entry2 = entry;
            ErrorCriteria errorCriteria = entry2.getValue();
            int acceptableErrorCount = errorCriteria.getAcceptableErrorCount();
            Integer n = stats2.getErrors().get(action.getLabel());
            int n2 = errorCount = n != null ? n : 0;
            if (errorCount > acceptableErrorCount) {
                verdict.addReport(new FailedAssertionJUnitReport(this.testMethodName(action, stats2.getCohort()), "The '" + action.getLabel() + "' action has failed " + errorCount + " times. " + "This is too much, because we only tolerate " + acceptableErrorCount + " such failures. " + "It happened on the '" + stats2.getCohort() + "' cohort."));
                continue;
            }
            verdict.addReport(new SuccessfulJUnitReport(this.testMethodName(action, stats2.getCohort())));
        }
        return verdict.build();
    }

    private final String testMethodName(ActionType<?> action, String cohort) {
        return "Error_count_for_" + cohort + '_' + action.getLabel();
    }
}

