/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.jfr;

import com.atlassian.performance.tools.report.api.jfr.JfrFilter;
import com.atlassian.performance.tools.report.jfr.FilteringJfrWriter;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Predicate;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jmc.flightrecorder.testutils.parser.StreamingChunkParser;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB)\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/report/api/jfr/JfrFilter;", "", "eventFilter", "Ljava/util/function/Predicate;", "Ljdk/jfr/consumer/RecordedEvent;", "filteredRecording", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "(Ljava/util/function/Predicate;Ljava/util/function/Function;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "filter", "Ljava/io/File;", "recording", "Builder", "report"})
public final class JfrFilter {
    private final Logger logger;
    private final Predicate<RecordedEvent> eventFilter;
    private final Function<Path, Path> filteredRecording;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File filter(@NotNull Path recording) {
        Intrinsics.checkParameterIsNotNull((Object)recording, (String)"recording");
        File filteredRecording2 = this.filteredRecording.apply(recording).toFile();
        this.logger.debug("Writing filtered recording to " + filteredRecording2 + " ...");
        File file = filteredRecording2;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"filteredRecording");
        Object object = file;
        object = new FileOutputStream((File)object);
        int n = 8192;
        object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream outputStream = (BufferedOutputStream)object;
            FilteringJfrWriter writer = new FilteringJfrWriter(filteredRecording2, outputStream, this.eventFilter);
            StreamingChunkParser parser = new StreamingChunkParser(writer);
            parser.parse(recording);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return filteredRecording2;
    }

    private JfrFilter(Predicate<RecordedEvent> eventFilter2, Function<Path, Path> filteredRecording2) {
        this.eventFilter = eventFilter2;
        this.filteredRecording = filteredRecording2;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public /* synthetic */ JfrFilter(@NotNull Predicate eventFilter2, @NotNull Function filteredRecording2, DefaultConstructorMarker $constructor_marker) {
        this(eventFilter2, filteredRecording2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u001a\u0010\u0006\u001a\u00020\u00002\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/report/api/jfr/JfrFilter$Builder;", "", "()V", "eventFilter", "Ljava/util/function/Predicate;", "Ljdk/jfr/consumer/RecordedEvent;", "filteredRecording", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "build", "Lcom/atlassian/performance/tools/report/api/jfr/JfrFilter;", "report"})
    public static final class Builder {
        private Predicate<RecordedEvent> eventFilter = eventFilter.1.INSTANCE;
        private Function<Path, Path> filteredRecording = filteredRecording.1.INSTANCE;

        @NotNull
        public final Builder eventFilter(@NotNull Predicate<RecordedEvent> eventFilter2) {
            Intrinsics.checkParameterIsNotNull(eventFilter2, (String)"eventFilter");
            this.eventFilter = eventFilter2;
            return this;
        }

        @NotNull
        public final Builder filteredRecording(@NotNull Function<Path, Path> filteredRecording2) {
            Intrinsics.checkParameterIsNotNull(filteredRecording2, (String)"filteredRecording");
            this.filteredRecording = filteredRecording2;
            return this;
        }

        @NotNull
        public final JfrFilter build() {
            return new JfrFilter(this.eventFilter, this.filteredRecording, null);
        }
    }
}

