/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.impact;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.api.impact.ClassifiedLatencyImpact;
import com.atlassian.performance.tools.report.api.impact.ImpactClassification;
import com.atlassian.performance.tools.report.api.impact.LatencyImpactMarkdownTable$WhenMappings;
import com.atlassian.performance.tools.workspace.api.TestWorkspace;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/report/api/impact/LatencyImpactMarkdownTable;", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/report/api/impact/ClassifiedLatencyImpact;", "workspace", "Lcom/atlassian/performance/tools/workspace/api/TestWorkspace;", "(Lcom/atlassian/performance/tools/workspace/api/TestWorkspace;)V", "allImpacts", "Ljava/util/TreeMap;", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "format", "", "accept", "", "newestImpact", "renderRow", "impact", "formatter", "Ljava/util/Formatter;", "report"})
public final class LatencyImpactMarkdownTable
implements Consumer<ClassifiedLatencyImpact> {
    private final TreeMap<ActionType<?>, ClassifiedLatencyImpact> allImpacts;
    private final String format = "| %-21s | %-14s | %-10s | %-14s | %-14s |\n";
    private final TestWorkspace workspace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(@NotNull ClassifiedLatencyImpact newestImpact) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)newestImpact, (String)"newestImpact");
        Object object2 = this.allImpacts;
        Object object3 = newestImpact.getAction();
        ClassifiedLatencyImpact classifiedLatencyImpact = newestImpact;
        object2.put(object3, classifiedLatencyImpact);
        File file = this.workspace.getDirectory().resolve("latency-impact-table.md").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"workspace.directory.reso\u2026mpact-table.md\").toFile()");
        object2 = file;
        object3 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        object3 = null;
        try {
            Map $receiver$iv;
            BufferedWriter writer = (BufferedWriter)object2;
            Formatter formatter = new Formatter(writer);
            formatter.format(this.format, "Action", "Classification", "Confidence", "Latency impact", "Latency impact");
            String dashes21 = StringsKt.repeat((CharSequence)"-", (int)21);
            String dashes14 = StringsKt.repeat((CharSequence)"-", (int)14);
            String dashes10 = StringsKt.repeat((CharSequence)"-", (int)10);
            writer.write("|-" + dashes21 + "-|-" + dashes14 + "-|-" + dashes10 + "-|-" + dashes14 + "-|-" + dashes14 + "-|\n");
            Map map2 = $receiver$iv = (Map)this.allImpacts;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $$_$_impact;
                Map.Entry entry = $$_$_impact = (element$iv = iterator.next());
                ClassifiedLatencyImpact impact = (ClassifiedLatencyImpact)entry.getValue();
                this.renderRow(impact, formatter);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, object3);
        }
    }

    private final void renderRow(ClassifiedLatencyImpact impact, Formatter formatter) {
        String typeLabel;
        String action = StringUtils.abbreviate((String)impact.getAction().getLabel(), (int)21);
        ImpactClassification classification = impact.getClassification();
        ImpactClassification.ImpactType impactType = classification.getImpactType();
        switch (LatencyImpactMarkdownTable$WhenMappings.$EnumSwitchMapping$0[impactType.ordinal()]) {
            case 1: {
                String string = "NO IMPACT";
                break;
            }
            default: {
                String string = typeLabel = impactType.toString();
            }
        }
        if (impactType == ImpactClassification.ImpactType.INCONCLUSIVE) {
            formatter.format(this.format, action, typeLabel, "N/A", "N/A", "N/A");
        } else {
            formatter.format(this.format, action, typeLabel, String.format("%.2f", classification.getConfidence() * (double)100) + " %", String.format("%+.0f", impact.getRelativeImpact() * (double)100) + " %", String.format("%+d", impact.getAbsoluteImpact().toMillis()) + " ms");
        }
    }

    public LatencyImpactMarkdownTable(@NotNull TestWorkspace workspace) {
        TreeMap treeMap;
        Intrinsics.checkParameterIsNotNull((Object)workspace, (String)"workspace");
        this.workspace = workspace;
        TreeMap treeMap2 = treeMap;
        TreeMap treeMap3 = treeMap;
        LatencyImpactMarkdownTable latencyImpactMarkdownTable = this;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                ActionType it = (ActionType)a;
                Comparable comparable = (Comparable)((Object)it.getLabel());
                it = (ActionType)b;
                Comparable comparable2 = comparable;
                String string = it.getLabel();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        treeMap2(comparator);
        latencyImpactMarkdownTable.allImpacts = treeMap3;
        this.format = "| %-21s | %-14s | %-10s | %-14s | %-14s |\n";
    }
}

