/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.jiraactions.api.ActionTypes;
import com.atlassian.performance.tools.report.api.CohortStatsSummary;
import com.atlassian.performance.tools.report.api.FullTimeline;
import com.atlassian.performance.tools.report.api.result.EdibleResult;
import com.atlassian.performance.tools.report.api.result.RawCohortResult;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.chart.MeanLatencyChart;
import com.atlassian.performance.tools.workspace.api.RootWorkspace;
import com.atlassian.performance.tools.workspace.api.TaskWorkspace;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/report/api/HistoricalCohortsReporter;", "", "workspace", "Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;", "(Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;)V", "actionTypes", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "dump", "", "extractResults", "Lcom/atlassian/performance/tools/report/api/result/EdibleResult;", "task", "Lcom/atlassian/performance/tools/workspace/api/TaskWorkspace;", "getStats", "", "Lcom/atlassian/performance/tools/report/api/result/Stats;", "report"})
public final class HistoricalCohortsReporter {
    private final Logger logger;
    private final List<ActionType<Object>> actionTypes;
    private final RootWorkspace workspace;

    /*
     * WARNING - void declaration
     */
    public final void dump() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection<Stats> stats2 = this.getStats();
        Iterable iterable = $receiver$iv = (Iterable)this.actionTypes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ActionType actionType = (ActionType)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getLabel();
            collection.add(string);
        }
        List labels = (List)destination$iv$iv;
        Path report = this.workspace.getDirectory().resolve("results.csv");
        File file = report.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"report.toFile()");
        new CohortStatsSummary(file, labels).report(stats2);
        Path chart = this.workspace.getDirectory().resolve("mean-latency-chart.html");
        MeanLatencyChart meanLatencyChart = new MeanLatencyChart();
        File file2 = chart.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"chart.toFile()");
        meanLatencyChart.plot(stats2, labels, file2);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Stats> getStats() {
        void var3_3;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.workspace.listTasks();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            EdibleResult edibleResult;
            Object element$iv$iv = element$iv$iv$iv;
            TaskWorkspace it = (TaskWorkspace)element$iv$iv;
            if (this.extractResults(it) == null) continue;
            EdibleResult it$iv$iv = edibleResult;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Object element$iv$iv$iv;
            element$iv$iv$iv = (EdibleResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            Stats stats2 = it.getStats();
            collection.add(stats2);
        }
        return (List)var3_3;
    }

    private final EdibleResult extractResults(TaskWorkspace task) {
        EdibleResult edibleResult;
        try {
            EdibleResult edibleResult2 = new RawCohortResult.Factory().fullResult(((Object)task.getDirectory().getFileName()).toString(), task.getDirectory()).prepareForJudgement(new FullTimeline());
            this.logger.info("Found previous results in " + task.getDirectory());
        }
        catch (Exception e) {
            this.logger.debug(task.getDirectory() + " has no results", (Throwable)e);
            edibleResult = null;
        }
        return edibleResult;
    }

    public HistoricalCohortsReporter(@NotNull RootWorkspace workspace) {
        Intrinsics.checkParameterIsNotNull((Object)workspace, (String)"workspace");
        this.workspace = workspace;
        this.logger = LogManager.getLogger(this.getClass());
        this.actionTypes = CollectionsKt.listOf((Object[])new ActionType[]{ActionTypes.VIEW_BOARD, ActionTypes.VIEW_ISSUE, ActionTypes.VIEW_DASHBOARD, ActionTypes.SEARCH_WITH_JQL, ActionTypes.ADD_COMMENT_SUBMIT, ActionTypes.CREATE_ISSUE_SUBMIT, ActionTypes.EDIT_ISSUE_SUBMIT, ActionTypes.PROJECT_SUMMARY, ActionTypes.BROWSE_PROJECTS, ActionTypes.BROWSE_BOARDS});
    }
}

