/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.report.MeanAggregator;
import com.atlassian.performance.tools.report.api.result.InteractionStats;
import com.atlassian.performance.tools.report.result.PerformanceStats;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Use CohortsReporter instead.")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\"\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/report/api/DataReporter;", "", "output", "Ljava/io/File;", "labels", "", "", "(Ljava/io/File;Ljava/util/List;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "report", "", "data", "", "Lcom/atlassian/performance/tools/report/api/result/InteractionStats;", "reportCsv", "target", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "serialize", "", "Ljava/time/Duration;"})
public final class DataReporter {
    private final Logger logger;
    private final File output;
    private final List<String> labels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void report(@NotNull Collection<InteractionStats> data) {
        Object object;
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        Object object2 = DirectoriesKt.ensureParentDirectory((File)this.output);
        Object object3 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        object3 = null;
        try {
            BufferedWriter it = (BufferedWriter)object2;
            this.reportCsv(data, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        this.logger.info("Performance results summary available at " + this.output.toURI());
    }

    private final void reportCsv(Collection<InteractionStats> data, Appendable target) {
        List list;
        Comparable<Duration> comparable;
        Object it;
        Collection<Duration> collection;
        Iterable $receiver$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv;
        Collection collection2;
        InteractionStats stats2;
        Collection<List> collection3;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        String[] headers2 = (String[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])new String[]{"cohort", "metric"}, (Collection)this.labels), (Object)"AGGREGATE");
        CSVFormat format = CSVFormat.DEFAULT.withHeader(Arrays.copyOf(headers2, headers2.length)).withRecordSeparator('\n');
        CSVPrinter printer = new CSVPrinter(target, format);
        Iterable iterable = data;
        CSVPrinter cSVPrinter = printer;
        void var7_8 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            InteractionStats interactionStats = (InteractionStats)item$iv$iv;
            collection3 = destination$iv$iv2;
            Iterable iterable2 = this.labels;
            collection2 = CollectionsKt.listOf((Object[])new String[]{stats2.getCohort$report(), "response time average"});
            void var14_15 = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                String string = (String)item$iv$iv2;
                collection = destination$iv$iv;
                Map<String, Duration> map2 = stats2.getCenters$report();
                comparable = map2 != null ? map2.get(it) : null;
                collection.add((Duration)comparable);
            }
            collection = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv = (Iterable)collection;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                it = (Duration)item$iv$iv2;
                collection = destination$iv$iv;
                Duration duration = it;
                comparable = duration != null ? Long.valueOf(this.serialize(duration)) : null;
                collection.add((Duration)comparable);
            }
            collection = (List)destination$iv$iv;
            list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (Object)new MeanAggregator().aggregateCenters(this.labels, PerformanceStats.Adapter.adapt(stats2)));
            collection3.add(list);
        }
        collection3 = (List)destination$iv$iv2;
        cSVPrinter.printRecords((Iterable)collection3);
        $receiver$iv2 = data;
        cSVPrinter = printer;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            stats2 = (InteractionStats)item$iv$iv;
            collection3 = destination$iv$iv2;
            $receiver$iv = this.labels;
            collection2 = CollectionsKt.listOf((Object[])new String[]{stats2.getCohort$report(), "request count"});
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                it = (String)item$iv$iv2;
                collection = destination$iv$iv;
                Map<String, Long> map3 = stats2.getSampleSizes$report();
                comparable = map3 != null ? map3.get(it) : null;
                collection.add((Duration)comparable);
            }
            collection = (List)destination$iv$iv;
            list = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            collection3.add(list);
        }
        collection3 = (List)destination$iv$iv2;
        cSVPrinter.printRecords((Iterable)collection3);
        $receiver$iv2 = data;
        cSVPrinter = printer;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            stats2 = (InteractionStats)item$iv$iv;
            collection3 = destination$iv$iv2;
            $receiver$iv = this.labels;
            collection2 = CollectionsKt.listOf((Object[])new String[]{stats2.getCohort$report(), "response time standard deviation"});
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                it = (String)item$iv$iv2;
                collection = destination$iv$iv;
                Map<String, Duration> map4 = stats2.getDispersions$report();
                comparable = map4 != null ? map4.get(it) : null;
                collection.add((Duration)comparable);
            }
            collection = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv = (Iterable)collection;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                it = (Duration)item$iv$iv2;
                collection = destination$iv$iv;
                Object object = it;
                comparable = object != null ? Long.valueOf(this.serialize((Duration)object)) : null;
                collection.add((Duration)comparable);
            }
            collection = (List)destination$iv$iv;
            list = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            collection3.add(list);
        }
        collection3 = (List)destination$iv$iv2;
        cSVPrinter.printRecords((Iterable)collection3);
        $receiver$iv2 = data;
        cSVPrinter = printer;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            stats2 = (InteractionStats)item$iv$iv;
            collection3 = destination$iv$iv2;
            $receiver$iv = this.labels;
            collection2 = CollectionsKt.listOf((Object[])new String[]{stats2.getCohort$report(), "error count"});
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                it = (String)item$iv$iv2;
                collection = destination$iv$iv;
                Map<String, Integer> map5 = stats2.getErrors$report();
                comparable = map5 != null ? map5.get(it) : null;
                collection.add((Duration)comparable);
            }
            collection = (List)destination$iv$iv;
            list = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            collection3.add(list);
        }
        collection3 = (List)destination$iv$iv2;
        cSVPrinter.printRecords((Iterable)collection3);
        printer.flush();
    }

    private final long serialize(@NotNull Duration $receiver) {
        return $receiver.toMillis();
    }

    public DataReporter(@NotNull File output, @NotNull List<String> labels) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        this.output = output;
        this.labels = labels;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

