/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jvmtasks.api;

import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0002\u000e\u000fB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/IdempotentAction;", "T", "", "description", "", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "retry", "maxAttempts", "", "backoff", "Lcom/atlassian/performance/tools/jvmtasks/api/Backoff;", "(ILcom/atlassian/performance/tools/jvmtasks/api/Backoff;)Ljava/lang/Object;", "Companion", "FailedAttempt", "jvm-tasks"})
public final class IdempotentAction<T> {
    private final String description;
    private final Function0<T> action;
    private static final Logger LOGGER;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final T retry(int maxAttempts, @NotNull Backoff backoff) {
        Intrinsics.checkParameterIsNotNull((Object)backoff, (String)"backoff");
        int n = 1;
        IntRange attempts = new IntRange(n, maxAttempts);
        List failedAttempts = new ArrayList();
        IntRange intRange = attempts;
        int n2 = intRange.getFirst();
        int n3 = intRange.getLast();
        if (n2 <= n3) {
            while (true) {
                try {
                    return (T)this.action.invoke();
                }
                catch (Exception e) {
                    void attempt;
                    FailedAttempt failedAttempt = new FailedAttempt((int)attempt, e, this.description);
                    Collection collection = failedAttempts;
                    collection.add(failedAttempt);
                    if (attempt != attempts.getLast()) {
                        Duration delay = backoff.backOff((int)attempt);
                        LOGGER.debug(failedAttempt + ", backing off for " + delay + " ...");
                        Thread.sleep(delay.toMillis());
                    }
                    if (attempt == n3) break;
                    ++attempt;
                    continue;
                }
                break;
            }
        }
        FailedAttempt lastAttempt = (FailedAttempt)CollectionsKt.last((List)failedAttempts);
        LOGGER.debug(lastAttempt + ", it was the last attempt");
        Iterable $receiver$iv = failedAttempts;
        for (Object element$iv : $receiver$iv) {
            FailedAttempt it = (FailedAttempt)element$iv;
            boolean bl = false;
            LOGGER.debug("Stacktrace for " + it, (Throwable)it.getFailure());
        }
        throw (Throwable)new Exception("Failed to " + this.description + " despite " + maxAttempts + " attempts", lastAttempt.getFailure());
    }

    public IdempotentAction(@NotNull String description, @NotNull Function0<? extends T> action) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.description = description;
        this.action = action;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LogManager.getLogger(Companion.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/IdempotentAction$FailedAttempt;", "", "attempt", "", "failure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "action", "", "(ILjava/lang/Exception;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "getAttempt", "()I", "getFailure", "()Ljava/lang/Exception;", "toString", "jvm-tasks"})
    private static final class FailedAttempt {
        private final int attempt;
        @NotNull
        private final Exception failure;
        @NotNull
        private final String action;

        @NotNull
        public String toString() {
            return "Attempt #" + this.attempt + " failed to " + this.action + ", " + this.failure.getMessage();
        }

        public final int getAttempt() {
            return this.attempt;
        }

        @NotNull
        public final Exception getFailure() {
            return this.failure;
        }

        @NotNull
        public final String getAction() {
            return this.action;
        }

        public FailedAttempt(int attempt, @NotNull Exception failure, @NotNull String action) {
            Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            this.attempt = attempt;
            this.failure = failure;
            this.action = action;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/IdempotentAction$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "jvm-tasks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

