/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jvmtasks.api;

import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/ExponentialBackoff;", "Lcom/atlassian/performance/tools/jvmtasks/api/Backoff;", "baseBackoff", "Ljava/time/Duration;", "exponent", "", "(Ljava/time/Duration;D)V", "backOff", "attempt", "", "jvm-tasks"})
public final class ExponentialBackoff
implements Backoff {
    private final Duration baseBackoff;
    private final double exponent;

    @Override
    @NotNull
    public Duration backOff(int attempt) {
        long factor = (long)Math.pow(this.exponent, attempt);
        Duration duration = this.baseBackoff.multipliedBy(factor);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"baseBackoff.multipliedBy(factor)");
        return duration;
    }

    public ExponentialBackoff(@NotNull Duration baseBackoff, double exponent) {
        Intrinsics.checkParameterIsNotNull((Object)baseBackoff, (String)"baseBackoff");
        this.baseBackoff = baseBackoff;
        this.exponent = exponent;
    }

    public /* synthetic */ ExponentialBackoff(Duration duration, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 2.0;
        }
        this(duration, d);
    }
}

