/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.os;

import com.atlassian.performance.tools.infrastructure.api.os.MonitoringProcess;
import com.atlassian.performance.tools.infrastructure.api.os.OsMetric;
import com.atlassian.performance.tools.infrastructure.api.process.RemoteMonitoringProcess;
import com.atlassian.performance.tools.ssh.api.DetachedProcess;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/performance/tools/infrastructure/os/Iostat;", "Lcom/atlassian/performance/tools/infrastructure/api/os/OsMetric;", "()V", "start", "Lcom/atlassian/performance/tools/infrastructure/api/process/RemoteMonitoringProcess;", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "startMonitoring", "Lcom/atlassian/performance/tools/infrastructure/api/os/MonitoringProcess;", "Companion", "infrastructure"})
public final class Iostat
implements OsMetric {
    private static final Duration DELAY;
    private static final String LOG_PATH = "~/jpt-iostat.log";
    private static final String TIME = "date -u \"+%d-%m-%Y %H:%M:%S UTC\"";
    private static final String ADD_TIME = "while IFS= read -r line; do echo \"$(date -u \"+%d-%m-%Y %H:%M:%S UTC\") $line\"; done";
    public static final Companion Companion;

    @Override
    @NotNull
    public MonitoringProcess startMonitoring(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        long seconds = DELAY.get(ChronoUnit.SECONDS);
        DetachedProcess process = connection.startProcess("iostat -d " + seconds + " -x | " + ADD_TIME + " > " + LOG_PATH);
        return new MonitoringProcess(process, LOG_PATH);
    }

    @Override
    @NotNull
    public RemoteMonitoringProcess start(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        long seconds = DELAY.get(ChronoUnit.SECONDS);
        DetachedProcess process = connection.startProcess("iostat -d " + seconds + " -x | " + ADD_TIME + " > " + LOG_PATH);
        return new MonitoringProcess(process, LOG_PATH);
    }

    static {
        Companion = new Companion(null);
        Duration duration = Duration.ofSeconds(2L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(2)");
        DELAY = duration;
        LOG_PATH = LOG_PATH;
        TIME = TIME;
        ADD_TIME = "while IFS= read -r line; do " + "echo \"$(" + TIME + ") $line\"; " + "done";
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/infrastructure/os/Iostat$Companion;", "", "()V", "ADD_TIME", "", "DELAY", "Ljava/time/Duration;", "LOG_PATH", "TIME", "infrastructure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

