/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.jira.install;

import com.atlassian.performance.tools.infrastructure.RemotePathExtensionsKt;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import com.atlassian.performance.tools.infrastructure.api.jvm.JavaDevelopmentKit;
import com.atlassian.performance.tools.infrastructure.api.os.RemotePath;
import com.atlassian.performance.tools.infrastructure.jira.install.InstalledJira;
import com.atlassian.performance.tools.infrastructure.jira.install.JiraInstallation;
import com.atlassian.performance.tools.infrastructure.jira.install.TcpServer;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/infrastructure/jira/install/SequentialInstallation;", "Lcom/atlassian/performance/tools/infrastructure/jira/install/JiraInstallation;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "jdk", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;", "(Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;)V", "install", "Lcom/atlassian/performance/tools/infrastructure/jira/install/InstalledJira;", "server", "Lcom/atlassian/performance/tools/infrastructure/jira/install/TcpServer;", "infrastructure"})
public final class SequentialInstallation
implements JiraInstallation {
    private final JiraHomeSource jiraHomeSource;
    private final ProductDistribution productDistribution;
    private final JavaDevelopmentKit jdk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InstalledJira install(@NotNull TcpServer server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Closeable closeable = (Closeable)server.getSsh().newConnection();
        Throwable throwable = null;
        try {
            SshConnection ssh = (SshConnection)closeable;
            RemotePath installation = RemotePathExtensionsKt.installRemotely(this.productDistribution, ssh, ".");
            RemotePath home = RemotePathExtensionsKt.downloadRemotely(this.jiraHomeSource, ssh);
            this.jdk.install(ssh);
            InstalledJira installedJira = new InstalledJira(home, installation, this.jdk, server);
            return installedJira;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public SequentialInstallation(@NotNull JiraHomeSource jiraHomeSource, @NotNull ProductDistribution productDistribution, @NotNull JavaDevelopmentKit jdk) {
        Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
        Intrinsics.checkParameterIsNotNull((Object)productDistribution, (String)"productDistribution");
        Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
        this.jiraHomeSource = jiraHomeSource;
        this.productDistribution = productDistribution;
        this.jdk = jdk;
    }
}

