/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.jira.install;

import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.RemotePathExtensionsKt;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import com.atlassian.performance.tools.infrastructure.api.jvm.JavaDevelopmentKit;
import com.atlassian.performance.tools.infrastructure.api.os.RemotePath;
import com.atlassian.performance.tools.infrastructure.jira.install.InstalledJira;
import com.atlassian.performance.tools.infrastructure.jira.install.JiraInstallation;
import com.atlassian.performance.tools.infrastructure.jira.install.ParallelInstallation;
import com.atlassian.performance.tools.infrastructure.jira.install.TcpServer;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/infrastructure/jira/install/ParallelInstallation;", "Lcom/atlassian/performance/tools/infrastructure/jira/install/JiraInstallation;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "jdk", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;", "(Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;)V", "install", "Lcom/atlassian/performance/tools/infrastructure/jira/install/InstalledJira;", "server", "Lcom/atlassian/performance/tools/infrastructure/jira/install/TcpServer;", "infrastructure"})
public final class ParallelInstallation
implements JiraInstallation {
    private final JiraHomeSource jiraHomeSource;
    private final ProductDistribution productDistribution;
    private final JavaDevelopmentKit jdk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InstalledJira install(@NotNull TcpServer server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Closeable closeable = (Closeable)server.getSsh().newConnection();
        Throwable throwable = null;
        try {
            ExecutorService pool2;
            SshConnection ssh = (SshConnection)closeable;
            ExecutorService executorService = pool2 = Executors.newCachedThreadPool(install.1.pool.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"pool");
            CompletableFuture product = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)"product", (Function0)((Function0)new Function0<RemotePath>(ssh, this, server){
                final /* synthetic */ SshConnection $ssh;
                final /* synthetic */ ParallelInstallation this$0;
                final /* synthetic */ TcpServer $server$inlined;
                {
                    this.$ssh = sshConnection;
                    this.this$0 = parallelInstallation;
                    this.$server$inlined = tcpServer;
                    super(0);
                }

                @NotNull
                public final RemotePath invoke() {
                    return RemotePathExtensionsKt.installRemotely(ParallelInstallation.access$getProductDistribution$p(this.this$0), this.$ssh, ".");
                }
            }));
            CompletableFuture home = TaskContextKt.submitWithLogContext((ExecutorService)pool2, (String)"home", (Function0)((Function0)new Function0<RemotePath>(ssh, this, server){
                final /* synthetic */ SshConnection $ssh;
                final /* synthetic */ ParallelInstallation this$0;
                final /* synthetic */ TcpServer $server$inlined;
                {
                    this.$ssh = sshConnection;
                    this.this$0 = parallelInstallation;
                    this.$server$inlined = tcpServer;
                    super(0);
                }

                @NotNull
                public final RemotePath invoke() {
                    return RemotePathExtensionsKt.downloadRemotely(ParallelInstallation.access$getJiraHomeSource$p(this.this$0), this.$ssh);
                }
            }));
            CompletableFuture java = TaskContextKt.submitWithLogContext((ExecutorService)pool2, (String)"java", (Function0)((Function0)new Function0<JavaDevelopmentKit>(ssh, this, server){
                final /* synthetic */ SshConnection $ssh;
                final /* synthetic */ ParallelInstallation this$0;
                final /* synthetic */ TcpServer $server$inlined;
                {
                    this.$ssh = sshConnection;
                    this.this$0 = parallelInstallation;
                    this.$server$inlined = tcpServer;
                    super(0);
                }

                @NotNull
                public final JavaDevelopmentKit invoke() {
                    JavaDevelopmentKit javaDevelopmentKit;
                    JavaDevelopmentKit it = javaDevelopmentKit = ParallelInstallation.access$getJdk$p(this.this$0);
                    it.install(this.$ssh);
                    return javaDevelopmentKit;
                }
            }));
            Object t = home.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"home.get()");
            RemotePath remotePath = (RemotePath)t;
            Object t2 = product.get();
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"product.get()");
            RemotePath remotePath2 = (RemotePath)t2;
            Object t3 = java.get();
            Intrinsics.checkExpressionValueIsNotNull(t3, (String)"java.get()");
            InstalledJira jira = new InstalledJira(remotePath, remotePath2, (JavaDevelopmentKit)t3, server);
            pool2.shutdownNow();
            InstalledJira installedJira = jira;
            return installedJira;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public ParallelInstallation(@NotNull JiraHomeSource jiraHomeSource, @NotNull ProductDistribution productDistribution, @NotNull JavaDevelopmentKit jdk) {
        Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
        Intrinsics.checkParameterIsNotNull((Object)productDistribution, (String)"productDistribution");
        Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
        this.jiraHomeSource = jiraHomeSource;
        this.productDistribution = productDistribution;
        this.jdk = jdk;
    }

    @NotNull
    public static final /* synthetic */ ProductDistribution access$getProductDistribution$p(ParallelInstallation $this) {
        return $this.productDistribution;
    }

    @NotNull
    public static final /* synthetic */ JiraHomeSource access$getJiraHomeSource$p(ParallelInstallation $this) {
        return $this.jiraHomeSource;
    }

    @NotNull
    public static final /* synthetic */ JavaDevelopmentKit access$getJdk$p(ParallelInstallation $this) {
        return $this.jdk;
    }
}

